/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigDecimal;
import java.util.Collections;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironmentWithAssumptions;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverFormulaWithAssumptionsTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    protected <T> InterpolatingProverEnvironmentWithAssumptions<T> newEnvironmentForTest() throws InvalidConfigurationException {
        InterpolatingProverEnvironmentWithAssumptions<?> env = this.context.newProverEnvironmentWithInterpolation();
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support solving under assumptions").that(env).isInstanceOf(InterpolatingProverEnvironmentWithAssumptions.class);
        return env;
    }

    @Test
    public <T> void basicAssumptionsTest() throws SolverException, InterruptedException, InvalidConfigurationException {
        this.requireInterpolation();
        NumeralFormula.IntegerFormula v1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("v1");
        NumeralFormula.IntegerFormula v2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("v2");
        BooleanFormula suffix1 = this.bmgr.makeVariable("suffix1");
        BooleanFormula suffix2 = this.bmgr.makeVariable("suffix2");
        BooleanFormula suffix3 = this.bmgr.makeVariable("suffix3");
        BooleanFormula term1 = this.bmgr.or(this.bmgr.and(this.imgr.equal(v1, this.imgr.makeNumber(BigDecimal.ONE)), this.bmgr.not(this.imgr.equal(v1, v2))), suffix1);
        BooleanFormula term2 = this.bmgr.or(this.imgr.equal(v2, this.imgr.makeNumber(BigDecimal.ONE)), suffix2);
        BooleanFormula term3 = this.bmgr.or(this.bmgr.not(this.imgr.equal(v1, this.imgr.makeNumber(BigDecimal.ONE))), suffix3);
        try (InterpolatingProverEnvironmentWithAssumptions env = this.newEnvironmentForTest();){
            Object firstPartForInterpolant = env.push(term1);
            env.push(term2);
            env.push(term3);
            Truth.assertThat((Boolean)env.isUnsatWithAssumptions(Lists.newArrayList((Object[])new BooleanFormula[]{this.bmgr.not(suffix1), this.bmgr.not(suffix2), suffix3}))).isTrue();
            Truth.assertThat((String)env.getInterpolant(Collections.singletonList(firstPartForInterpolant)).toString()).doesNotContain((CharSequence)"suffix");
            Truth.assertThat((Boolean)env.isUnsatWithAssumptions(Lists.newArrayList((Object[])new BooleanFormula[]{this.bmgr.not(suffix1), this.bmgr.not(suffix3), suffix2}))).isTrue();
            Truth.assertThat((String)env.getInterpolant(Collections.singletonList(firstPartForInterpolant)).toString()).doesNotContain((CharSequence)"suffix");
        }
    }
}

