/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Truth;
import java.util.Iterator;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverFormulaIOTest
extends SolverBasedTest0 {
    private static final String MATHSAT_DUMP1 = "(set-info :source |printed by MathSAT|)\n(declare-fun a () Bool)\n(declare-fun b () Bool)\n(declare-fun d () Bool)\n(declare-fun e () Bool)\n(define-fun .def_9 () Bool (= a b))\n(define-fun .def_10 () Bool (not .def_9))\n(define-fun .def_13 () Bool (and .def_10 d))\n(define-fun .def_14 () Bool (or e .def_13))\n(assert .def_14)";
    private static final String MATHSAT_DUMP2 = "(set-info :source |printed by MathSAT|)\n(declare-fun a () Int)\n(declare-fun b () Int)\n(declare-fun c () Int)\n(declare-fun q () Bool)\n(declare-fun u () Bool)\n(define-fun .def_15 () Int (* (- 1) c))\n(define-fun .def_16 () Int (+ b .def_15))\n(define-fun .def_17 () Int (+ a .def_16))\n(define-fun .def_19 () Bool (= .def_17 0))\n(define-fun .def_27 () Bool (= .def_19 q))\n(define-fun .def_28 () Bool (not .def_27))\n(define-fun .def_23 () Bool (<= b a))\n(define-fun .def_29 () Bool (and .def_23 .def_28))\n(define-fun .def_11 () Bool (= a b))\n(define-fun .def_34 () Bool (and .def_11 .def_29))\n(define-fun .def_30 () Bool (or u .def_29))\n(define-fun .def_31 () Bool (and q .def_30))\n(define-fun .def_35 () Bool (and .def_31 .def_34))\n(assert .def_35)";
    private static final String MATHSAT_DUMP3 = "(set-info :source |printed by MathSAT|)\n(declare-fun fun_b (Int) Bool)\n(define-fun .def_11 () Bool (fun_b 1))\n(assert .def_11)";
    private static final String SMTINTERPOL_DUMP1 = "(declare-fun d () Bool)\n(declare-fun b () Bool)\n(declare-fun a () Bool)\n(declare-fun e () Bool)\n(assert (or e (and (xor a b) d)))";
    private static final String SMTINTERPOL_DUMP2 = "(declare-fun b () Int)(declare-fun a () Int)\n(declare-fun c () Int)\n(declare-fun q () Bool)\n(declare-fun u () Bool)\n(assert (let ((.cse0 (xor q (= (+ a b) c))) (.cse1 (>= a b))) (and (or (and .cse0 .cse1) u) q (= a b) .cse0 .cse1)))";
    private static final String Z3_DUMP1 = "(declare-fun d () Bool)\n(declare-fun b () Bool)\n(declare-fun a () Bool)\n(declare-fun e () Bool)\n(assert  (or e (and (xor a b) d)))";
    private static final String Z3_DUMP2 = "(declare-fun b () Int)\n(declare-fun a () Int)\n(declare-fun c () Int)\n(declare-fun q () Bool)\n(declare-fun u () Bool)\n(assert  (let (($x35 (and (xor q (= (+ a b) c)) (>= a b)))) (let (($x9 (= a b))) (and (and (or $x35 u) q) (and $x9 $x35)))))";
    private Supplier<BooleanFormula> boolExprGen1 = new Supplier<BooleanFormula>(){

        public BooleanFormula get() {
            return SolverFormulaIOTest.this.genBoolExpr();
        }
    };
    private Supplier<BooleanFormula> boolExprGen2 = new Supplier<BooleanFormula>(){

        public BooleanFormula get() {
            return SolverFormulaIOTest.this.redundancyExprGen();
        }
    };
    private Supplier<BooleanFormula> boolExprGen3 = new Supplier<BooleanFormula>(){

        public BooleanFormula get() {
            return SolverFormulaIOTest.this.functionExprGen();
        }
    };
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void varDumpTest() {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c1 = this.bmgr.xor(a, b);
        BooleanFormula c2 = this.bmgr.xor(a, b);
        BooleanFormula d = this.bmgr.and(c1, c2);
        String formDump = this.mgr.dumpFormula(d).toString();
        Truth.assertThat((String)formDump).contains((CharSequence)"(declare-fun a () Bool)");
        Truth.assertThat((String)formDump).contains((CharSequence)"(declare-fun b () Bool)");
        this.checkThatAssertIsInLastLine(formDump);
        this.checkThatDumpIsParseable(formDump);
    }

    @Test
    public void varDumpTest2() {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c1 = this.bmgr.xor(a, b);
        BooleanFormula c2 = this.bmgr.and(a, b);
        BooleanFormula d = this.bmgr.or(c1, c2);
        BooleanFormula e = this.bmgr.and(a, d);
        BooleanFormula x1 = this.bmgr.xor(a, b);
        BooleanFormula x2 = this.bmgr.and(a, b);
        BooleanFormula w = this.bmgr.or(x1, x2);
        BooleanFormula v = this.bmgr.or(x1, b);
        BooleanFormula branch1 = this.bmgr.and(d, e);
        BooleanFormula branch2 = this.bmgr.and(w, v);
        BooleanFormula branchComp = this.bmgr.or(branch1, branch2);
        String formDump = this.mgr.dumpFormula(branchComp).toString();
        Truth.assertThat((String)formDump).contains((CharSequence)"(declare-fun a () Bool)");
        Truth.assertThat((String)formDump).contains((CharSequence)"(declare-fun b () Bool)");
        this.checkThatDumpIsParseable(formDump);
    }

    @Test
    public void valDumpTest() {
        BooleanFormula tr1 = this.bmgr.makeBoolean(true);
        BooleanFormula tr2 = this.bmgr.makeBoolean(true);
        BooleanFormula fl1 = this.bmgr.makeBoolean(false);
        BooleanFormula fl2 = this.bmgr.makeBoolean(false);
        BooleanFormula valComp = this.bmgr.and(fl1, tr1);
        BooleanFormula valComp2 = this.bmgr.and(fl1, tr1);
        BooleanFormula valComp3 = this.bmgr.and(tr2, valComp);
        BooleanFormula valComp4 = this.bmgr.and(fl2, valComp2);
        BooleanFormula valComp5 = this.bmgr.or(valComp3, valComp4);
        String formDump = this.mgr.dumpFormula(valComp5).toString();
        this.checkThatAssertIsInLastLine(formDump);
        this.checkThatDumpIsParseable(formDump);
    }

    @Test
    public void intsDumpTest() {
        NumeralFormula.IntegerFormula f1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.IntegerFormula val = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        BooleanFormula formula = this.imgr.equal(f1, val);
        String formDump = this.mgr.dumpFormula(formula).toString();
        Truth.assertThat((String)formDump).contains((CharSequence)"(declare-fun a () Int)");
        this.checkThatAssertIsInLastLine(formDump);
        this.checkThatDumpIsParseable(formDump);
    }

    @Test
    public void funcsDumpTest() {
        NumeralFormula.IntegerFormula int1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula var = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("var_a");
        ImmutableList args1 = ImmutableList.of((Object)int1, (Object)var);
        FunctionDeclaration<NumeralFormula.IntegerFormula> funA = this.fmgr.declareUF("fun_a", FormulaType.IntegerType, FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula res1 = this.fmgr.callUF(funA, (List<? extends Formula>)args1);
        BooleanFormula formula = this.imgr.equal(res1, var);
        String formDump = this.mgr.dumpFormula(formula).toString();
        Truth.assertThat((String)formDump).contains((CharSequence)"(declare-fun fun_a (Int Int) Int)");
        this.checkThatAssertIsInLastLine(formDump);
        this.checkThatDumpIsParseable(formDump);
    }

    @Test
    public void parseMathSatTestParseFirst1() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(MATHSAT_DUMP1, this.boolExprGen1);
    }

    @Test
    public void parseMathSatTestExprFirst1() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(MATHSAT_DUMP1, this.boolExprGen1);
    }

    @Test
    public void parseSmtinterpolTestParseFirst1() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(SMTINTERPOL_DUMP1, this.boolExprGen1);
    }

    @Test
    public void parseSmtinterpolTestExprFirst1() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(SMTINTERPOL_DUMP1, this.boolExprGen1);
    }

    @Test
    public void parseZ3TestParseFirst1() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(Z3_DUMP1, this.boolExprGen1);
    }

    @Test
    public void parseZ3TestExprFirst1() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(Z3_DUMP1, this.boolExprGen1);
    }

    @Test
    public void parseMathSatTestParseFirst2() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(MATHSAT_DUMP2, this.boolExprGen2);
    }

    @Test
    public void parseMathSatTestExprFirst2() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(MATHSAT_DUMP2, this.boolExprGen2);
    }

    @Test
    public void parseSmtinterpolSatTestParseFirst2() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(SMTINTERPOL_DUMP2, this.boolExprGen2);
    }

    @Test
    public void parseSmtinterpolSatTestExprFirst2() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(SMTINTERPOL_DUMP2, this.boolExprGen2);
    }

    @Test
    public void parseZ3SatTestParseFirst2() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(Z3_DUMP2, this.boolExprGen2);
    }

    @Test
    public void parseZ3SatTestExprFirst2() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(Z3_DUMP2, this.boolExprGen2);
    }

    @Test
    public void parseMathSatTestExprFirst3() throws SolverException, InterruptedException {
        this.compareParseWithOrgExprFirst(MATHSAT_DUMP3, this.boolExprGen3);
    }

    public void parseMathSatTestParseFirst3() throws SolverException, InterruptedException {
        this.compareParseWithOrgParseFirst(MATHSAT_DUMP3, this.boolExprGen3);
    }

    @Test
    public void redundancyTest() {
        String formDump = this.mgr.dumpFormula(this.redundancyExprGen()).toString();
        int count = Iterables.size((Iterable)Splitter.on((String)">=").split((CharSequence)formDump)) - 1;
        int count2 = Iterables.size((Iterable)Splitter.on((String)"<=").split((CharSequence)formDump)) - 1;
        ((BooleanSubject)Truth.assertThat((Boolean)(count == 1 || count2 == 1 ? 1 : 0)).named(formDump + " does not contain <= or >= only once.")).isTrue();
    }

    @Test
    public void funDeclareTest() {
        NumeralFormula.IntegerFormula int1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula int2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        FunctionDeclaration<NumeralFormula.IntegerFormula> funA = this.fmgr.declareUF("fun_a", FormulaType.IntegerType, FormulaType.IntegerType);
        FunctionDeclaration<NumeralFormula.IntegerFormula> funB = this.fmgr.declareUF("fun_b", FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula res1 = this.fmgr.callUF(funA, (List<? extends Formula>)ImmutableList.of((Object)int1));
        NumeralFormula.IntegerFormula res2 = this.fmgr.callUF(funB, (List<? extends Formula>)ImmutableList.of((Object)int2));
        NumeralFormula.IntegerFormula calc = (NumeralFormula.IntegerFormula)this.imgr.add(res1, res2);
        String formDump = this.mgr.dumpFormula(this.imgr.equal(calc, int1)).toString();
        this.checkThatFunOnlyDeclaredOnce(formDump);
        this.checkThatAssertIsInLastLine(formDump);
        this.checkThatDumpIsParseable(formDump);
    }

    @Test
    public void funDeclareTest2() {
        NumeralFormula.IntegerFormula int1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula int2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        FunctionDeclaration<NumeralFormula.IntegerFormula> funA = this.fmgr.declareUF("fun_a", FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula res1 = this.fmgr.callUF(funA, (List<? extends Formula>)ImmutableList.of((Object)int1));
        NumeralFormula.IntegerFormula res2 = this.fmgr.callUF(funA, (List<? extends Formula>)ImmutableList.of((Object)int2));
        NumeralFormula.IntegerFormula calc = (NumeralFormula.IntegerFormula)this.imgr.add(res1, res2);
        String formDump = this.mgr.dumpFormula(this.imgr.equal(calc, int1)).toString();
        this.checkThatFunOnlyDeclaredOnce(formDump);
        this.checkThatAssertIsInLastLine(formDump);
        this.checkThatDumpIsParseable(formDump);
    }

    private void compareParseWithOrgExprFirst(String textToParse, Supplier<BooleanFormula> fun) throws SolverException, InterruptedException {
        this.checkThatFunOnlyDeclaredOnce(textToParse);
        this.checkThatAssertIsInLastLine(textToParse);
        BooleanFormula expr = (BooleanFormula)fun.get();
        BooleanFormula parsedForm = this.mgr.parse(textToParse);
        this.assertThatFormula(parsedForm).isEquivalentTo(expr);
    }

    private void compareParseWithOrgParseFirst(String textToParse, Supplier<BooleanFormula> fun) throws SolverException, InterruptedException {
        this.checkThatFunOnlyDeclaredOnce(textToParse);
        this.checkThatAssertIsInLastLine(textToParse);
        BooleanFormula parsedForm = this.mgr.parse(textToParse);
        BooleanFormula expr = (BooleanFormula)fun.get();
        this.assertThatFormula(parsedForm).isEquivalentTo(expr);
    }

    private void checkThatFunOnlyDeclaredOnce(String formDump) {
        HashMultiset funDeclares = HashMultiset.create();
        for (String line : Splitter.on((char)'\n').split((CharSequence)formDump)) {
            if (!line.startsWith("(declare-fun ")) continue;
            funDeclares.add((Object)line.replaceAll("\\s+", ""));
        }
        Iterator it = funDeclares.entrySet().iterator();
        while (it.hasNext()) {
            if (((Multiset.Entry)it.next()).getCount() > 1) continue;
            it.remove();
        }
        ((MultisetSubject)Truth.assertThat((Multiset)funDeclares).named("duplicate function declarations")).isEmpty();
    }

    private void checkThatAssertIsInLastLine(String lines) {
        lines = lines.trim();
        ((StringSubject)Truth.assertThat((String)((String)Iterables.getLast((Iterable)Splitter.on((char)'\n').split((CharSequence)lines)))).named("last line of <\n" + lines + ">")).startsWith("(assert ");
    }

    private void checkThatDumpIsParseable(String dump) {
        this.mgr.parse(dump);
    }

    private BooleanFormula genBoolExpr() {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.xor(a, b);
        BooleanFormula d = this.bmgr.makeVariable("d");
        BooleanFormula e = this.bmgr.makeVariable("e");
        BooleanFormula f = this.bmgr.and(c, d);
        return this.bmgr.or(e, f);
    }

    private BooleanFormula redundancyExprGen() {
        NumeralFormula.IntegerFormula i1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.IntegerFormula i2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        NumeralFormula.IntegerFormula erg = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c");
        BooleanFormula b1 = this.bmgr.makeVariable("q");
        BooleanFormula b2 = this.bmgr.makeVariable("u");
        BooleanFormula f1 = this.imgr.equal(this.imgr.add(i1, i2), erg);
        BooleanFormula comp1 = this.imgr.greaterOrEquals(i1, i2);
        BooleanFormula x1 = this.bmgr.xor(b1, f1);
        BooleanFormula comb1 = this.bmgr.and(x1, comp1);
        BooleanFormula r1a = this.bmgr.or(comb1, b2);
        BooleanFormula r1b = this.bmgr.and(r1a, b1);
        BooleanFormula r2a = this.imgr.equal(i1, i2);
        BooleanFormula r2b = this.bmgr.and(r2a, comb1);
        return this.bmgr.and(r1b, r2b);
    }

    private BooleanFormula functionExprGen() {
        NumeralFormula.IntegerFormula arg = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        FunctionDeclaration<BooleanFormula> funA = this.fmgr.declareUF("fun_b", FormulaType.BooleanType, FormulaType.IntegerType);
        BooleanFormula res1 = this.fmgr.callUF(funA, (List<? extends Formula>)ImmutableList.of((Object)arg));
        return this.bmgr.and(res1, this.bmgr.makeBoolean(true));
    }
}

