/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.SolverContext;

public class MemoryApp {
    private final FormulaManager fmgr;
    private final BooleanFormulaManager bfmgr;
    private final IntegerFormulaManager ifmgr;
    private final SolverContext context;

    public static void main(String[] args) throws Exception {
        new MemoryApp().run();
    }

    MemoryApp() throws InvalidConfigurationException {
        Configuration config = Configuration.builder().build();
        BasicLogManager logger = new BasicLogManager(config);
        ShutdownNotifier notifier = ShutdownManager.create().getNotifier();
        this.context = SolverContextFactory.createSolverContext(config, (LogManager)logger, notifier, SolverContextFactory.Solvers.MATHSAT5);
        this.fmgr = this.context.getFormulaManager();
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.ifmgr = this.fmgr.getIntegerFormulaManager();
    }

    void run() throws InterruptedException {
        System.out.printf("Running...", new Object[0]);
        boolean i = false;
        while (true) {
            BooleanFormula booleanFormula = this.bfmgr.or(this.bfmgr.and(this.bfmgr.makeVariable("a"), this.bfmgr.makeVariable("b")), this.bfmgr.and(this.bfmgr.makeVariable("c"), this.bfmgr.makeVariable("d")));
        }
    }
}

