/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolArrayFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolBooleanFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaCreator;
import org.sosy_lab.solver.smtinterpol.SmtInterpolIntegerFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolRationalFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolUFManager;
import org.sosy_lab.solver.visitors.FormulaVisitor;

class SmtInterpolFormulaManager
extends AbstractFormulaManager<Term, Sort, SmtInterpolEnvironment, FunctionSymbol> {
    SmtInterpolFormulaManager(SmtInterpolFormulaCreator pCreator, SmtInterpolUFManager pFunctionManager, SmtInterpolBooleanFormulaManager pBooleanManager, SmtInterpolIntegerFormulaManager pIntegerManager, SmtInterpolRationalFormulaManager pRationalManager, SmtInterpolArrayFormulaManager pArrayFormulaManager) {
        super(pCreator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, null, null, null, pArrayFormulaManager);
    }

    BooleanFormula encapsulateBooleanFormula(Term t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        Term term = (Term)Iterables.getOnlyElement(((SmtInterpolEnvironment)this.getEnvironment()).parseStringToTerms(pS));
        return this.encapsulateBooleanFormula(new FormulaUnLet().unlet(term));
    }

    @Override
    public Appender dumpFormula(final Term formula) {
        assert (this.getFormulaCreator().getFormulaType(formula) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                HashSet<Term> seen = new HashSet<Term>();
                HashSet<FunctionSymbol> declaredFunctions = new HashSet<FunctionSymbol>();
                ArrayDeque<Term> todo = new ArrayDeque<Term>();
                PrintTerm termPrinter = new PrintTerm();
                todo.addLast(formula);
                while (!todo.isEmpty()) {
                    Term t = (Term)todo.removeLast();
                    while (t instanceof AnnotatedTerm) {
                        t = ((AnnotatedTerm)t).getSubterm();
                    }
                    if (!(t instanceof ApplicationTerm) || !seen.add(t)) continue;
                    ApplicationTerm term = (ApplicationTerm)t;
                    Collections.addAll(todo, term.getParameters());
                    FunctionSymbol func = term.getFunction();
                    if (func.isIntern()) continue;
                    if (func.getDefinition() == null) {
                        if (!declaredFunctions.add(func)) continue;
                        out.append("(declare-fun ");
                        out.append(PrintTerm.quoteIdentifier((String)func.getName()));
                        out.append(" (");
                        int counter = 0;
                        for (Sort paramSort : func.getParameterSorts()) {
                            termPrinter.append(out, paramSort);
                            if (++counter >= func.getParameterSorts().length) continue;
                            out.append(' ');
                        }
                        out.append(") ");
                        termPrinter.append(out, func.getReturnSort());
                        out.append(")\n");
                        continue;
                    }
                    throw new IllegalArgumentException("Terms with definition are unsupported.");
                }
                out.append("(assert ");
                Term letted = new FormulaLet().let(formula);
                termPrinter.append(out, letted);
                out.append(")");
            }
        };
    }

    @Override
    public <R> R visit(FormulaVisitor<R> rFormulaVisitor, Formula f) {
        return this.getFormulaCreator().visit(rFormulaVisitor, f);
    }

    SmtInterpolEnvironment createEnvironment() {
        return (SmtInterpolEnvironment)this.getEnvironment();
    }

    @Override
    public Term simplify(Term pF) {
        return ((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).simplify(pF);
    }

    @Override
    protected List<Term> splitNumeralEqualityIfPossible(Term pF) {
        if (pF instanceof ApplicationTerm && "=".equals(((ApplicationTerm)pF).getFunction().getName()) && ((ApplicationTerm)pF).getParameters().length == 2) {
            Term arg0 = ((ApplicationTerm)pF).getParameters()[0];
            Term arg1 = ((ApplicationTerm)pF).getParameters()[1];
            assert (arg0 != null && arg1 != null);
            assert (arg0.getSort().equals(arg1.getSort()));
            if (arg0.getTheory().getBooleanSort() != arg0.getSort()) {
                return ImmutableList.of((Object)((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).term("<=", arg0, arg1), (Object)((SmtInterpolEnvironment)this.getFormulaCreator().getEnv()).term("<=", arg1, arg0));
            }
        }
        return ImmutableList.of((Object)pF);
    }
}

