/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5ArrayFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5BitvectorFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5BooleanFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5FloatingPointFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5Formula;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5IntegerFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.mathsat5.Mathsat5RationalFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5UFManager;

final class Mathsat5FormulaManager
extends AbstractFormulaManager<Long, Long, Long, Long> {
    Mathsat5FormulaManager(Mathsat5FormulaCreator creator, Mathsat5UFManager pFunctionManager, Mathsat5BooleanFormulaManager pBooleanManager, Mathsat5IntegerFormulaManager pIntegerManager, Mathsat5RationalFormulaManager pRationalManager, Mathsat5BitvectorFormulaManager pBitpreciseManager, Mathsat5FloatingPointFormulaManager pFloatingPointManager, Mathsat5ArrayFormulaManager pArrayManager) {
        super(creator, pFunctionManager, pBooleanManager, pIntegerManager, pRationalManager, pBitpreciseManager, pFloatingPointManager, null, pArrayManager);
    }

    static long getMsatTerm(Formula pT) {
        return ((Mathsat5Formula)pT).getTerm();
    }

    BooleanFormula encapsulateBooleanFormula(long t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        long f = Mathsat5NativeApi.msat_from_smtlib2((Long)this.getEnvironment(), pS);
        return this.encapsulateBooleanFormula(f);
    }

    @Override
    public Appender dumpFormula(final Long f) {
        assert (this.getFormulaCreator().getFormulaType(f) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return Appenders.fromToStringMethod((Object)new Object(){

            public String toString() {
                String msatString = Mathsat5NativeApi.msat_to_smtlib2((Long)Mathsat5FormulaManager.this.getEnvironment(), f);
                StringBuilder smtString = new StringBuilder();
                boolean needsLinebreak = true;
                for (String part : msatString.split("\n")) {
                    smtString.append(part);
                    if (part.startsWith("(assert")) {
                        needsLinebreak = false;
                    }
                    if (!needsLinebreak) continue;
                    smtString.append("\n");
                }
                return smtString.toString();
            }
        });
    }

    @Override
    protected List<Long> splitNumeralEqualityIfPossible(Long pF) {
        long msatEnv = (Long)this.getFormulaCreator().getEnv();
        if (Mathsat5NativeApi.msat_term_is_equal(msatEnv, pF) && Mathsat5NativeApi.msat_term_arity(pF) == 2) {
            long arg0 = Mathsat5NativeApi.msat_term_get_arg(pF, 0);
            long arg1 = Mathsat5NativeApi.msat_term_get_arg(pF, 1);
            long type = Mathsat5NativeApi.msat_term_get_type(arg0);
            if (Mathsat5NativeApi.msat_is_bv_type(msatEnv, type)) {
                return ImmutableList.of((Object)Mathsat5NativeApi.msat_make_bv_uleq(msatEnv, arg0, arg1), (Object)Mathsat5NativeApi.msat_make_bv_uleq(msatEnv, arg1, arg0));
            }
            if (Mathsat5NativeApi.msat_is_integer_type(msatEnv, type) || Mathsat5NativeApi.msat_is_rational_type(msatEnv, type)) {
                return ImmutableList.of((Object)Mathsat5NativeApi.msat_make_leq(msatEnv, arg0, arg1), (Object)Mathsat5NativeApi.msat_make_leq(msatEnv, arg1, arg0));
            }
        }
        return ImmutableList.of((Object)pF);
    }

    @Override
    public <T extends Formula> T substitute(T pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        return this.substituteUsingLists(pF, pFromToMapping);
    }

    @Override
    protected Long substituteUsingListsImpl(Long t, List<Long> changeFrom, List<Long> changeTo) {
        int size = changeFrom.size();
        Preconditions.checkState((size == changeTo.size() ? 1 : 0) != 0);
        return Mathsat5NativeApi.msat_apply_substitution((Long)this.getEnvironment(), t, size, Longs.toArray(changeFrom), Longs.toArray(changeTo));
    }
}

