/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.logging;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;

public class LoggingOptimizationProverEnvironment
implements OptimizationProverEnvironment {
    private final OptimizationProverEnvironment wrapped;
    private final LogManager logger;

    public LoggingOptimizationProverEnvironment(LogManager logger, OptimizationProverEnvironment oe) {
        this.wrapped = (OptimizationProverEnvironment)Preconditions.checkNotNull((Object)oe);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public Void addConstraint(BooleanFormula constraint) {
        this.logger.log(Level.FINE, new Object[]{"Asserting: " + constraint});
        return (Void)this.wrapped.addConstraint(constraint);
    }

    @Override
    public int maximize(Formula objective) {
        this.logger.log(Level.FINE, new Object[]{"Maximizing: " + objective});
        return this.wrapped.maximize(objective);
    }

    @Override
    public int minimize(Formula objective) {
        this.logger.log(Level.FINE, new Object[]{"Minimizing: " + objective});
        return this.wrapped.minimize(objective);
    }

    @Override
    public OptimizationProverEnvironment.OptStatus check() throws InterruptedException, SolverException {
        this.logger.log(Level.FINE, new Object[]{"Performing optimization"});
        return this.wrapped.check();
    }

    @Override
    public void push() {
        this.logger.log(Level.FINE, new Object[]{"Creating backtracking point"});
        this.wrapped.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"Checking satisfiability"});
        return this.wrapped.isUnsat();
    }

    @Override
    @Nullable
    public Void push(BooleanFormula f) {
        this.logger.log(Level.FINE, new Object[]{"Pushing", f, "and creating a backtracking point"});
        return (Void)this.wrapped.push(f);
    }

    @Override
    public void pop() {
        this.logger.log(Level.FINE, new Object[]{"Backtracking one level"});
        this.wrapped.pop();
    }

    @Override
    public Optional<Rational> upper(int handle, Rational epsilon) {
        return this.wrapped.upper(handle, epsilon);
    }

    @Override
    public Optional<Rational> lower(int handle, Rational epsilon) {
        return this.wrapped.lower(handle, epsilon);
    }

    @Override
    public Model getModel() throws SolverException {
        return this.wrapped.getModel();
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

