/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.logging;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironmentWithAssumptions;
import org.sosy_lab.solver.api.Model;

public class LoggingInterpolatingProverEnvironment<T>
implements InterpolatingProverEnvironmentWithAssumptions<T> {
    private final InterpolatingProverEnvironmentWithAssumptions<T> wrapped;
    private final LogManager logger;
    int level = 0;

    public LoggingInterpolatingProverEnvironment(LogManager logger, InterpolatingProverEnvironmentWithAssumptions<T> ipe) {
        this.wrapped = (InterpolatingProverEnvironmentWithAssumptions)Preconditions.checkNotNull(ipe);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public T push(BooleanFormula f) {
        ++this.level;
        this.logger.log(Level.FINER, new Object[]{"up to level " + this.level});
        this.logger.log(Level.FINE, new Object[]{"formula pushed:", f});
        Object result = this.wrapped.push(f);
        return result;
    }

    @Override
    public void pop() {
        --this.level;
        this.logger.log(Level.FINER, new Object[]{"down to level " + this.level});
        this.wrapped.pop();
    }

    @Override
    public T addConstraint(BooleanFormula constraint) {
        return this.wrapped.addConstraint(constraint);
    }

    @Override
    public void push() {
        this.logger.log(Level.FINER, new Object[]{"up to level " + ++this.level});
        this.wrapped.push();
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        boolean result = this.wrapped.isUnsat();
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public boolean isUnsatWithAssumptions(List<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"assumptions:", pAssumptions});
        boolean result = this.wrapped.isUnsatWithAssumptions(pAssumptions);
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public BooleanFormula getInterpolant(List<T> formulasOfA) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", formulasOfA});
        BooleanFormula bf = this.wrapped.getInterpolant(formulasOfA);
        this.logger.log(Level.FINE, new Object[]{"interpolant:", bf});
        return bf;
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<T>> partitionedFormulas) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", partitionedFormulas});
        List<BooleanFormula> bf = this.wrapped.getSeqInterpolants(partitionedFormulas);
        this.logger.log(Level.FINE, new Object[]{"interpolants:", bf});
        return bf;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<T>> partitionedFormulas, int[] startOfSubTree) throws SolverException, InterruptedException {
        this.logger.log(Level.FINE, new Object[]{"formulasOfA:", partitionedFormulas});
        this.logger.log(Level.FINE, new Object[]{"startOfSubTree:", startOfSubTree});
        List<BooleanFormula> bf = this.wrapped.getTreeInterpolants(partitionedFormulas, startOfSubTree);
        this.logger.log(Level.FINE, new Object[]{"interpolants:", bf});
        return bf;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

