/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.api;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.NumeralFormula;

public interface Model
extends Iterable<ValueAssignment> {
    @Nullable
    public Object evaluate(Formula var1);

    @Nullable
    public BigInteger evaluate(NumeralFormula.IntegerFormula var1);

    @Nullable
    public Rational evaluate(NumeralFormula.RationalFormula var1);

    @Nullable
    public Boolean evaluate(BooleanFormula var1);

    @Nullable
    public BigInteger evaluate(BitvectorFormula var1);

    @Override
    public Iterator<ValueAssignment> iterator();

    public String toString();

    public static final class ValueAssignment {
        private final Formula key;
        private final Object value;
        private final ImmutableList<Object> argumentsInterpretation;
        private final String name;

        public ValueAssignment(Formula key, String name, Object value, Collection<?> argumentInterpretation) {
            this.key = (Formula)Preconditions.checkNotNull((Object)key);
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.value = Preconditions.checkNotNull((Object)value);
            this.argumentsInterpretation = ImmutableList.copyOf(argumentInterpretation);
        }

        public Formula getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public ImmutableList<Object> getArgumentsInterpretation() {
            return this.argumentsInterpretation;
        }

        public boolean isFunction() {
            return !this.argumentsInterpretation.isEmpty();
        }

        public int getArity() {
            return this.argumentsInterpretation.size();
        }

        public Object getArgInterpretation(int i) {
            assert (i < this.getArity());
            return this.argumentsInterpretation.get(i);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append(this.name);
            if (!this.argumentsInterpretation.isEmpty()) {
                sb.append("(");
                Joiner.on((String)", ").appendTo(sb, this.argumentsInterpretation);
                sb.append(")");
            }
            return sb.append(": ").append(this.value).toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueAssignment)) {
                return false;
            }
            ValueAssignment other = (ValueAssignment)o;
            boolean out = this.name.equals(other.name) && this.value.equals(other.value) && this.argumentsInterpretation.equals(other.argumentsInterpretation);
            return out;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentsInterpretation, this.value);
        }
    }
}

