/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.microsoft.z3.ArraySort;
import com.microsoft.z3.BitVecSort;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntSymbol;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.Sort;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.visitors.FormulaVisitor;

class Z3FormulaCreator
extends FormulaCreator<Expr, Sort, Context> {
    private final Table<Sort, Sort, Sort> allocatedArraySorts = HashBasedTable.create();

    Z3FormulaCreator(Context pEnv, Sort pBoolType, Sort pIntegerType, Sort pRealType) {
        super(pEnv, pBoolType, pIntegerType, pRealType);
    }

    @Override
    public Expr makeVariable(Sort type, String varName) {
        Context z3context = (Context)this.getEnv();
        StringSymbol symbol = z3context.mkSymbol(varName);
        return z3context.mkConst((Symbol)symbol, type);
    }

    @Override
    public Expr extractInfo(Formula pT) {
        return (Expr)super.extractInfo(pT);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof ArrayFormula || pFormula instanceof BitvectorFormula) {
            Expr term = this.extractInfo(pFormula);
            return this.getFormulaType(term);
        }
        return super.getFormulaType(pFormula);
    }

    public FormulaType<?> getFormulaTypeFromSort(Sort pSort) {
        switch (pSort.getSortKind()) {
            case Z3_BOOL_SORT: {
                return FormulaType.BooleanType;
            }
            case Z3_INT_SORT: {
                return FormulaType.IntegerType;
            }
            case Z3_REAL_SORT: {
                return FormulaType.RationalType;
            }
            case Z3_ARRAY_SORT: {
                Preconditions.checkArgument((boolean)(pSort instanceof ArraySort));
                ArraySort aSort = (ArraySort)pSort;
                return FormulaType.getArrayType(this.getFormulaTypeFromSort(aSort.getDomain()), this.getFormulaTypeFromSort(aSort.getRange()));
            }
            case Z3_BV_SORT: {
                Preconditions.checkArgument((boolean)(pSort instanceof BitVecSort));
                return FormulaType.getBitvectorTypeWithSize(((BitVecSort)pSort).getSize());
            }
        }
        throw new IllegalArgumentException("Unknown formula type");
    }

    @Override
    public FormulaType<?> getFormulaType(Expr pFormula) {
        return this.getFormulaTypeFromSort(pFormula.getSort());
    }

    @Override
    public Sort getArrayType(Sort pIndexType, Sort pElementType) {
        Sort allocatedArraySort = (Sort)this.allocatedArraySorts.get((Object)pIndexType, (Object)pElementType);
        if (allocatedArraySort == null) {
            allocatedArraySort = ((Context)this.getEnv()).mkArraySort(pIndexType, pElementType);
            this.allocatedArraySorts.put((Object)pIndexType, (Object)pElementType, (Object)allocatedArraySort);
        }
        return allocatedArraySort;
    }

    @Override
    public Sort getBitvectorType(int pBitwidth) {
        Preconditions.checkArgument((pBitwidth > 0 ? 1 : 0) != 0, (String)"Cannot use bitvector type with size %s", (Object[])new Object[]{pBitwidth});
        return ((Context)this.getEnv()).mkBitVecSort(pBitwidth);
    }

    @Override
    public Sort getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by Z3");
    }

    private String getName(Expr t) {
        Z3_ast_kind astKind = t.getASTKind();
        if (astKind == Z3_ast_kind.Z3_VAR_AST) {
            return "?" + t.getIndex();
        }
        FuncDecl funcDecl = t.getFuncDecl();
        Symbol symbol = funcDecl.getName();
        if (symbol instanceof IntSymbol) {
            return Integer.toString(((IntSymbol)symbol).getInt());
        }
        if (symbol instanceof StringSymbol) {
            return ((StringSymbol)symbol).getString();
        }
        throw new AssertionError();
    }

    private Expr replaceArgs(Expr t, List<Expr> newArgs) {
        Preconditions.checkState((t.getNumArgs() == newArgs.size() ? 1 : 0) != 0);
        Expr[] newParams = newArgs.toArray(new Expr[0]);
        return ((Context)this.environment).mkApp(t.getFuncDecl(), newParams);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, final Expr f) {
        switch (f.getASTKind()) {
            case Z3_NUMERAL_AST: {
                return visitor.visitConstant(formula, this.convertValue(f));
            }
            case Z3_APP_AST: {
                String name = this.getName(f);
                int arity = f.getNumArgs();
                if (arity == 0) {
                    Z3_decl_kind declKind = f.getFuncDecl().getDeclKind();
                    if (declKind == Z3_decl_kind.Z3_OP_TRUE || declKind == Z3_decl_kind.Z3_OP_FALSE) {
                        return visitor.visitConstant(formula, declKind == Z3_decl_kind.Z3_OP_TRUE);
                    }
                    return visitor.visitFreeVariable(formula, name);
                }
                ArrayList<Formula> args = new ArrayList<Formula>(arity);
                for (int i = 0; i < arity; ++i) {
                    Expr arg = f.getArgs()[i];
                    FormulaType<?> argumentType = this.getFormulaType(arg);
                    args.add((Formula)this.encapsulate(argumentType, arg));
                }
                Function<List<Formula>, Formula> constructor = new Function<List<Formula>, Formula>(){

                    public Formula apply(List<Formula> formulas) {
                        return Z3FormulaCreator.this.encapsulateWithTypeOf(Z3FormulaCreator.this.replaceArgs(f, Z3FormulaCreator.this.extractInfo(formulas)));
                    }
                };
                return visitor.visitFunction(formula, args, FunctionDeclaration.of(name, this.getDeclarationKind(f)), constructor);
            }
            case Z3_VAR_AST: {
                int deBruijnIdx = f.getIndex();
                return visitor.visitBoundVariable(formula, deBruijnIdx);
            }
            case Z3_QUANTIFIER_AST: {
                Preconditions.checkArgument((boolean)(f instanceof Quantifier));
                Quantifier qf = (Quantifier)f;
                BooleanFormula body = this.encapsulateBoolean(qf.getBody());
                QuantifiedFormulaManager.Quantifier q = qf.isUniversal() ? QuantifiedFormulaManager.Quantifier.FORALL : QuantifiedFormulaManager.Quantifier.EXISTS;
                return visitor.visitQuantifier((BooleanFormula)formula, q, this.getBoundVars(qf), body);
            }
        }
        throw new UnsupportedOperationException("Input should be a formula AST, got unexpected type instead");
    }

    private List<Formula> getBoundVars(Quantifier pQf) {
        int numBound = pQf.getNumBound();
        ArrayList<Formula> boundVars = new ArrayList<Formula>(numBound);
        Symbol[] varNames = pQf.getBoundVariableNames();
        Sort[] varSorts = pQf.getBoundVariableSorts();
        for (int i = 0; i < numBound; ++i) {
            boundVars.add((Formula)this.encapsulate(this.getFormulaTypeFromSort(varSorts[i]), ((Context)this.environment).mkConst(varNames[i], varSorts[i])));
        }
        return boundVars;
    }

    private FunctionDeclarationKind getDeclarationKind(Expr pF) {
        Z3_decl_kind decl = pF.getFuncDecl().getDeclKind();
        if (pF.getArgs().length == 0) {
            return FunctionDeclarationKind.VAR;
        }
        switch (decl) {
            case Z3_OP_AND: {
                return FunctionDeclarationKind.AND;
            }
            case Z3_OP_NOT: {
                return FunctionDeclarationKind.NOT;
            }
            case Z3_OP_OR: {
                return FunctionDeclarationKind.OR;
            }
            case Z3_OP_IFF: {
                return FunctionDeclarationKind.IFF;
            }
            case Z3_OP_ITE: {
                return FunctionDeclarationKind.ITE;
            }
            case Z3_OP_XOR: {
                return FunctionDeclarationKind.XOR;
            }
            case Z3_OP_DISTINCT: {
                return FunctionDeclarationKind.DISTINCT;
            }
            case Z3_OP_IMPLIES: {
                return FunctionDeclarationKind.IMPLIES;
            }
            case Z3_OP_SUB: {
                return FunctionDeclarationKind.SUB;
            }
            case Z3_OP_ADD: {
                return FunctionDeclarationKind.ADD;
            }
            case Z3_OP_DIV: {
                return FunctionDeclarationKind.DIV;
            }
            case Z3_OP_MUL: {
                return FunctionDeclarationKind.MUL;
            }
            case Z3_OP_MOD: {
                return FunctionDeclarationKind.MODULO;
            }
            case Z3_OP_UNINTERPRETED: {
                return FunctionDeclarationKind.UF;
            }
            case Z3_OP_LT: {
                return FunctionDeclarationKind.LT;
            }
            case Z3_OP_LE: {
                return FunctionDeclarationKind.LTE;
            }
            case Z3_OP_GT: {
                return FunctionDeclarationKind.GT;
            }
            case Z3_OP_GE: {
                return FunctionDeclarationKind.GTE;
            }
            case Z3_OP_EQ: {
                return FunctionDeclarationKind.EQ;
            }
        }
        return FunctionDeclarationKind.OTHER;
    }

    public Object convertValue(Expr pF) {
        FormulaType<?> type = this.getFormulaType(pF);
        if (type.isBooleanType()) {
            return pF.isTrue();
        }
        if (type.isIntegerType()) {
            return new BigInteger(pF.toString());
        }
        if (type.isRationalType()) {
            return Rational.ofString((String)pF.toString());
        }
        if (type.isBitvectorType()) {
            return Z3FormulaCreator.interpretBitvector(pF);
        }
        return pF.toString();
    }

    private static BigInteger interpretBitvector(Expr pF) {
        Sort argSort = pF.getSort();
        Z3_sort_kind sortKind = argSort.getSortKind();
        Preconditions.checkArgument((sortKind == Z3_sort_kind.Z3_BV_SORT ? 1 : 0) != 0);
        return new BigInteger(pF.toString());
    }
}

