/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Sort;
import java.math.BigInteger;
import org.sosy_lab.solver.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;

class Z3BitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Expr, Sort, Context> {
    private final Context z3context;

    Z3BitvectorFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Context)creator.getEnv();
    }

    static BitVecExpr toBV(Expr e) {
        return (BitVecExpr)e;
    }

    @Override
    public Expr concat(Expr pFirst, Expr pSecond) {
        return this.z3context.mkConcat(Z3BitvectorFormulaManager.toBV(pFirst), Z3BitvectorFormulaManager.toBV(pSecond));
    }

    @Override
    public Expr extract(Expr pFirst, int pMsb, int pLsb, boolean pSigned) {
        return this.z3context.mkExtract(pMsb, pLsb, Z3BitvectorFormulaManager.toBV(pFirst));
    }

    @Override
    public Expr extend(Expr pNumber, int pExtensionBits, boolean pSigned) {
        if (pSigned) {
            return this.z3context.mkSignExt(pExtensionBits, Z3BitvectorFormulaManager.toBV(pNumber));
        }
        return this.z3context.mkZeroExt(pExtensionBits, Z3BitvectorFormulaManager.toBV(pNumber));
    }

    @Override
    public Expr makeBitvectorImpl(int pLength, long pI) {
        return this.z3context.mkBV(pI, pLength);
    }

    @Override
    protected Expr makeBitvectorImpl(int pLength, BigInteger pI) {
        return this.z3context.mkBV(pI.toString(), pLength);
    }

    @Override
    public Expr makeVariableImpl(int length, String varName) {
        Sort type = (Sort)this.getFormulaCreator().getBitvectorType(length);
        return (Expr)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    public Expr shiftRight(Expr number, Expr toShift, boolean signed) {
        if (signed) {
            return this.z3context.mkBVASHR(Z3BitvectorFormulaManager.toBV(number), Z3BitvectorFormulaManager.toBV(toShift));
        }
        return this.z3context.mkBVLSHR(Z3BitvectorFormulaManager.toBV(number), Z3BitvectorFormulaManager.toBV(toShift));
    }

    @Override
    public Expr shiftLeft(Expr number, Expr toShift) {
        return this.z3context.mkBVSHL(Z3BitvectorFormulaManager.toBV(number), Z3BitvectorFormulaManager.toBV(toShift));
    }

    @Override
    public Expr not(Expr pBits) {
        return this.z3context.mkBVNot(Z3BitvectorFormulaManager.toBV(pBits));
    }

    @Override
    public Expr and(Expr pBits1, Expr pBits2) {
        return this.z3context.mkBVAND(Z3BitvectorFormulaManager.toBV(pBits1), Z3BitvectorFormulaManager.toBV(pBits2));
    }

    @Override
    public Expr or(Expr pBits1, Expr pBits2) {
        return this.z3context.mkBVOR(Z3BitvectorFormulaManager.toBV(pBits1), Z3BitvectorFormulaManager.toBV(pBits2));
    }

    @Override
    public Expr xor(Expr pBits1, Expr pBits2) {
        return this.z3context.mkBVXOR(Z3BitvectorFormulaManager.toBV(pBits1), Z3BitvectorFormulaManager.toBV(pBits2));
    }

    @Override
    public Expr negate(Expr pNumber) {
        return this.z3context.mkBVNeg(Z3BitvectorFormulaManager.toBV(pNumber));
    }

    @Override
    public Expr add(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkBVAdd(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr subtract(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkBVSub(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr divide(Expr pNumber1, Expr pNumber2, boolean signed) {
        if (signed) {
            return this.z3context.mkBVSDiv(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
        }
        return this.z3context.mkBVUDiv(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr modulo(Expr pNumber1, Expr pNumber2, boolean signed) {
        if (signed) {
            return this.z3context.mkBVSRem(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
        }
        return this.z3context.mkBVURem(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    protected Expr modularCongruence(Expr pNumber1, Expr pNumber2, long pModulo) {
        return this.z3context.mkTrue();
    }

    @Override
    public Expr multiply(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkBVMul(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr equal(Expr pNumber1, Expr pNumber2) {
        return this.z3context.mkEq((Expr)Z3BitvectorFormulaManager.toBV(pNumber1), (Expr)Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr lessThan(Expr pNumber1, Expr pNumber2, boolean signed) {
        if (signed) {
            return this.z3context.mkBVSLT(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
        }
        return this.z3context.mkBVULT(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr lessOrEquals(Expr pNumber1, Expr pNumber2, boolean signed) {
        if (signed) {
            return this.z3context.mkBVSLE(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
        }
        return this.z3context.mkBVULE(Z3BitvectorFormulaManager.toBV(pNumber1), Z3BitvectorFormulaManager.toBV(pNumber2));
    }

    @Override
    public Expr greaterThan(Expr pNumber1, Expr pNumber2, boolean signed) {
        return this.lessThan(pNumber2, pNumber1, signed);
    }

    @Override
    public Expr greaterOrEquals(Expr pNumber1, Expr pNumber2, boolean signed) {
        return this.lessOrEquals(pNumber2, pNumber1, signed);
    }
}

