/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Sort;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;

class Z3ArrayFormulaManager
extends AbstractArrayFormulaManager<Expr, Sort, Context> {
    private final Context z3context;

    Z3ArrayFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Context)creator.getEnv();
    }

    private static ArrayExpr toAE(Expr e) {
        return (ArrayExpr)e;
    }

    @Override
    protected Expr select(Expr pArray, Expr pIndex) {
        return this.z3context.mkSelect(Z3ArrayFormulaManager.toAE(pArray), pIndex);
    }

    @Override
    protected Expr store(Expr pArray, Expr pIndex, Expr pValue) {
        return this.z3context.mkStore(Z3ArrayFormulaManager.toAE(pArray), pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Expr internalMakeArray(String pName, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        FormulaType.ArrayFormulaType<TI, TE> arrayFormulaType = FormulaType.getArrayType(pIndexType, pElementType);
        Sort z3ArrayType = (Sort)this.toSolverType(arrayFormulaType);
        return (Expr)this.getFormulaCreator().makeVariable(z3ArrayType, pName);
    }

    @Override
    protected Expr equivalence(Expr pArray1, Expr pArray2) {
        return this.z3context.mkEq((Expr)Z3ArrayFormulaManager.toAE(pArray1), (Expr)Z3ArrayFormulaManager.toAE(pArray2));
    }
}

