/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.google.common.base.Preconditions;
import com.microsoft.z3.Context;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3Model;

abstract class Z3AbstractProver<T>
implements BasicProverEnvironment<T> {
    protected final Z3FormulaCreator creator;
    protected final Context z3context;
    protected final List<BooleanFormula> storedConstraints;
    protected boolean closed = false;
    protected final ShutdownNotifier shutdownNotifier;

    protected Z3AbstractProver(Z3FormulaCreator creator, ShutdownNotifier pShutdownNotifier) {
        this.creator = creator;
        this.z3context = (Context)creator.getEnv();
        this.storedConstraints = new ArrayList<BooleanFormula>();
        this.shutdownNotifier = pShutdownNotifier;
    }

    protected abstract com.microsoft.z3.Model getZ3Model();

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return new Z3Model(this.getZ3Model(), this.creator, this.storedConstraints);
    }

    @Override
    public T push(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.push();
        return this.addConstraint(f);
    }

    void trackConstraint(BooleanFormula f) {
        this.storedConstraints.add(f);
    }
}

