/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import java.io.IOException;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractSolverContext;
import org.sosy_lab.solver.z3.Z3ArrayFormulaManager;
import org.sosy_lab.solver.z3.Z3BitvectorFormulaManager;
import org.sosy_lab.solver.z3.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3FormulaManager;
import org.sosy_lab.solver.z3.Z3FunctionFormulaManager;
import org.sosy_lab.solver.z3.Z3IntegerFormulaManager;
import org.sosy_lab.solver.z3.Z3InterpolatingProver;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3OptimizationProver;
import org.sosy_lab.solver.z3.Z3QuantifiedFormulaManager;
import org.sosy_lab.solver.z3.Z3RationalFormulaManager;
import org.sosy_lab.solver.z3.Z3TheoremProver;

@Options(prefix="solver.z3", deprecatedPrefix="cpa.predicate.solver.z3")
public final class Z3SolverContext
extends AbstractSolverContext {
    @Option(secure=true, description="Engine to use for the optimization", values={"basic", "farkas", "symba"})
    String optimizationEngine = "basic";
    @Option(secure=true, description="Ordering for objectives in the optimization context", values={"lex", "pareto", "box"})
    String objectivePrioritizationMode = "box";
    private final ShutdownNotifier.ShutdownRequestListener interruptListener;
    private final long z3params;
    private final ShutdownNotifier shutdownNotifier;
    private final LogManager logger;
    private final Z3FormulaCreator creator;
    private final Z3FormulaManager manager;
    private static final String OPT_ENGINE_CONFIG_KEY = "optsmt_engine";
    private static final String OPT_PRIORITY_CONFIG_KEY = "priority";

    private Z3SolverContext(Z3FormulaCreator pFormulaCreator, Configuration config, long pZ3params, ShutdownNotifier.ShutdownRequestListener pInterruptListener, ShutdownNotifier pShutdownNotifier, LogManager pLogger, Z3FormulaManager pManager) throws InvalidConfigurationException {
        super(config, pLogger, pManager);
        this.creator = pFormulaCreator;
        config.inject((Object)this);
        this.z3params = pZ3params;
        this.interruptListener = pInterruptListener;
        pShutdownNotifier.register(this.interruptListener);
        this.shutdownNotifier = pShutdownNotifier;
        this.logger = pLogger;
        this.manager = pManager;
    }

    public static synchronized Z3SolverContext create(LogManager logger, Configuration config, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate solverLogfile, long randomSeed) throws InvalidConfigurationException {
        ExtraOptions extraOptions = new ExtraOptions();
        config.inject((Object)extraOptions);
        if (solverLogfile != null) {
            logger.log(Level.WARNING, new Object[]{"Z3 does not support dumping a log file in SMTLIB format. Please use the option solver.z3.log for a Z3-specific log instead."});
        }
        if (NativeLibraries.OS.guessOperatingSystem() == NativeLibraries.OS.WINDOWS) {
            NativeLibraries.loadLibrary((String)"libz3");
        }
        NativeLibraries.loadLibrary((String)"z3j");
        if (extraOptions.log != null) {
            Path absolutePath = extraOptions.log.toAbsolutePath();
            try {
                Files.writeFile((Path)absolutePath, (Object)"");
                Z3NativeApi.open_log(absolutePath.toString());
            }
            catch (IOException e) {
                logger.logUserException(Level.WARNING, (Throwable)e, "Cannot write Z3 log file");
            }
        }
        long cfg = Z3NativeApi.mk_config();
        Z3NativeApi.set_param_value(cfg, "MODEL", "true");
        if (extraOptions.requireProofs) {
            Z3NativeApi.set_param_value(cfg, "PROOF", "true");
        }
        Z3NativeApi.global_param_set("smt.random_seed", String.valueOf(randomSeed));
        final long context = Z3NativeApi.mk_context_rc(cfg);
        ShutdownNotifier.ShutdownRequestListener interruptListener = new ShutdownNotifier.ShutdownRequestListener(){

            public void shutdownRequested(String reason) {
                Z3NativeApi.interrupt(context);
            }
        };
        Z3NativeApi.del_config(cfg);
        long boolSort = Z3NativeApi.mk_bool_sort(context);
        Z3NativeApi.inc_ref(context, Z3NativeApi.sort_to_ast(context, boolSort));
        long integerSort = Z3NativeApi.mk_int_sort(context);
        Z3NativeApi.inc_ref(context, Z3NativeApi.sort_to_ast(context, integerSort));
        long realSort = Z3NativeApi.mk_real_sort(context);
        Z3NativeApi.inc_ref(context, Z3NativeApi.sort_to_ast(context, realSort));
        Z3NativeApi.set_ast_print_mode(context, 3);
        long z3params = Z3NativeApi.mk_params(context);
        Z3NativeApi.params_inc_ref(context, z3params);
        Z3NativeApi.params_set_uint(context, z3params, Z3NativeApi.mk_string_symbol(context, ":random-seed"), (int)randomSeed);
        Z3FormulaCreator creator = new Z3FormulaCreator(context, boolSort, integerSort, realSort, config);
        Z3FunctionFormulaManager functionTheory = new Z3FunctionFormulaManager(creator);
        Z3BooleanFormulaManager booleanTheory = new Z3BooleanFormulaManager(creator);
        Z3IntegerFormulaManager integerTheory = new Z3IntegerFormulaManager(creator);
        Z3RationalFormulaManager rationalTheory = new Z3RationalFormulaManager(creator);
        Z3BitvectorFormulaManager bitvectorTheory = new Z3BitvectorFormulaManager(creator);
        Z3QuantifiedFormulaManager quantifierManager = new Z3QuantifiedFormulaManager(creator);
        Z3ArrayFormulaManager arrayManager = new Z3ArrayFormulaManager(creator);
        Z3NativeApi.setInternalErrorHandler(context);
        Z3FormulaManager manager = new Z3FormulaManager(creator, functionTheory, booleanTheory, integerTheory, rationalTheory, bitvectorTheory, quantifierManager, arrayManager);
        return new Z3SolverContext(creator, config, z3params, interruptListener, pShutdownNotifier, logger, manager);
    }

    @Override
    public Z3FormulaManager getFormulaManager() {
        return this.manager;
    }

    @Override
    public ProverEnvironment newProverEnvironment0(SolverContext.ProverOptions ... options) {
        return new Z3TheoremProver(this.creator, this.manager, this.z3params, this.shutdownNotifier, options);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0() {
        return new Z3InterpolatingProver(this.creator, this.z3params, this.shutdownNotifier);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        Z3OptimizationProver out = new Z3OptimizationProver(this.getFormulaManager(), this.creator, this.shutdownNotifier, this.logger);
        out.setParam(OPT_ENGINE_CONFIG_KEY, this.optimizationEngine);
        out.setParam(OPT_PRIORITY_CONFIG_KEY, this.objectivePrioritizationMode);
        return out;
    }

    @Override
    public String getVersion() {
        Z3NativeApi.PointerToInt major = new Z3NativeApi.PointerToInt();
        Z3NativeApi.PointerToInt minor = new Z3NativeApi.PointerToInt();
        Z3NativeApi.PointerToInt build = new Z3NativeApi.PointerToInt();
        Z3NativeApi.PointerToInt revision = new Z3NativeApi.PointerToInt();
        Z3NativeApi.get_version(major, minor, build, revision);
        return "Z3 " + major.value + "." + minor.value + "." + build.value + "." + revision.value;
    }

    @Override
    public void close() {
        long context = (Long)this.creator.getEnv();
        Z3NativeApi.params_dec_ref(context, this.z3params);
        Z3NativeApi.del_context(context);
    }

    @Options(prefix="solver.z3")
    private static class ExtraOptions {
        @Option(secure=true, description="Require proofs from SMT solver")
        boolean requireProofs = true;
        @Option(secure=true, description="Activate replayable logging in Z3. The log can be given as an input to the solver and replayed.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        @Nullable
        Path log = null;

        private ExtraOptions() {
        }
    }
}

