/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;

class Z3Model
extends AbstractModel<Long, Long, Long> {
    private final long model;
    private final long z3context;
    private final Z3FormulaCreator creator;
    @Nullable
    private ImmutableList<Model.ValueAssignment> assignments = null;

    private Z3Model(long z3context, long z3model, Z3FormulaCreator pCreator) {
        super(pCreator);
        Z3NativeApi.model_inc_ref(z3context, z3model);
        this.model = z3model;
        this.z3context = z3context;
        this.creator = pCreator;
    }

    static Z3Model create(long z3context, long z3model, Z3FormulaCreator pCreator) {
        Z3Model model = new Z3Model(z3context, z3model, pCreator);
        pCreator.storeModelPhantomReference(model, z3model);
        pCreator.cleanupModelReferences();
        return model;
    }

    @Override
    @Nullable
    public Object evaluateImpl(Long f) {
        Z3NativeApi.PointerToLong out = new Z3NativeApi.PointerToLong();
        boolean status = Z3NativeApi.model_eval(this.z3context, this.model, f, true, out);
        Verify.verify((boolean)status, (String)"Error during model evaluation", (Object[])new Object[0]);
        if (out.value == 0L) {
            return null;
        }
        return this.creator.convertValue(out.value);
    }

    @Override
    public Iterator<Model.ValueAssignment> iterator() {
        if (this.assignments == null) {
            this.assignments = this.modelToList();
        }
        return this.assignments.iterator();
    }

    private ImmutableList<Model.ValueAssignment> modelToList() {
        ImmutableList.Builder out = ImmutableList.builder();
        for (int i = 0; i < Z3NativeApi.model_get_num_consts(this.z3context, this.model); ++i) {
            long keyDecl = Z3NativeApi.model_get_const_decl(this.z3context, this.model, i);
            Z3NativeApi.inc_ref(this.z3context, keyDecl);
            Preconditions.checkArgument((Z3NativeApi.get_arity(this.z3context, keyDecl) == 0 ? 1 : 0) != 0, (Object)"Declaration is not a constant");
            long var = Z3NativeApi.mk_app(this.z3context, keyDecl, new long[0]);
            Formula key = this.creator.encapsulateWithTypeOf(var);
            long value = Z3NativeApi.model_get_const_interp(this.z3context, this.model, keyDecl);
            Z3NativeApi.inc_ref(this.z3context, value);
            long symbol = Z3NativeApi.get_decl_name(this.z3context, keyDecl);
            assert (Z3NativeApi.get_symbol_kind(this.z3context, symbol) == 1);
            String name = Z3NativeApi.get_symbol_string(this.z3context, symbol);
            Object lValue = this.creator.convertValue(value);
            Z3NativeApi.dec_ref(this.z3context, keyDecl);
            Z3NativeApi.dec_ref(this.z3context, value);
            out.add((Object)new Model.ValueAssignment(key, name, lValue, (Collection<?>)ImmutableList.of()));
        }
        for (int funcIdx = 0; funcIdx < Z3NativeApi.model_get_num_funcs(this.z3context, this.model); ++funcIdx) {
            long funcDecl = Z3NativeApi.model_get_func_decl(this.z3context, this.model, funcIdx);
            Z3NativeApi.inc_ref(this.z3context, funcDecl);
            long symbol = Z3NativeApi.get_decl_name(this.z3context, funcDecl);
            assert (Z3NativeApi.get_symbol_kind(this.z3context, symbol) == 1);
            String name = Z3NativeApi.get_symbol_string(this.z3context, symbol);
            long interp = Z3NativeApi.model_get_func_interp(this.z3context, this.model, funcDecl);
            Z3NativeApi.func_interp_inc_ref(this.z3context, interp);
            int numInterpretations = Z3NativeApi.func_interp_get_num_entries(this.z3context, interp);
            for (int interpIdx = 0; interpIdx < numInterpretations; ++interpIdx) {
                long entry = Z3NativeApi.func_interp_get_entry(this.z3context, interp, interpIdx);
                Z3NativeApi.func_entry_inc_ref(this.z3context, entry);
                Object value = this.creator.convertValue(Z3NativeApi.func_entry_get_value(this.z3context, entry));
                int noArgs = Z3NativeApi.func_entry_get_num_args(this.z3context, entry);
                long[] args = new long[noArgs];
                ArrayList<Object> argumentInterpretation = new ArrayList<Object>();
                for (int k = 0; k < noArgs; ++k) {
                    long arg = Z3NativeApi.func_entry_get_arg(this.z3context, entry, k);
                    Z3NativeApi.inc_ref(this.z3context, arg);
                    argumentInterpretation.add(this.evaluateImpl(arg));
                    args[k] = arg;
                }
                Formula formula = this.creator.encapsulateWithTypeOf(Z3NativeApi.mk_app(this.z3context, funcDecl, args));
                for (long arg : args) {
                    Z3NativeApi.dec_ref(this.z3context, arg);
                }
                Z3NativeApi.func_entry_dec_ref(this.z3context, entry);
                out.add((Object)new Model.ValueAssignment(formula, name, value, argumentInterpretation));
            }
            Z3NativeApi.func_interp_dec_ref(this.z3context, interp);
            Z3NativeApi.dec_ref(this.z3context, funcDecl);
        }
        return out.build();
    }
}

