/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.visitors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;

public abstract class BooleanFormulaTransformationVisitor
implements BooleanFormulaVisitor<BooleanFormula> {
    private final BooleanFormulaManager bfmgr;
    private final FormulaManager manager;
    private final Map<BooleanFormula, BooleanFormula> cache;

    protected BooleanFormulaTransformationVisitor(FormulaManager pFmgr, Map<BooleanFormula, BooleanFormula> pCache) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.manager = pFmgr;
        this.cache = pCache;
    }

    protected final BooleanFormula visitIfNotSeen(BooleanFormula f) {
        BooleanFormula out = this.cache.get(f);
        if (out == null) {
            out = this.bfmgr.visit(this, f);
            this.cache.put(f, out);
        }
        return out;
    }

    protected final List<BooleanFormula> visitIfNotSeen(List<BooleanFormula> pOperands) {
        ArrayList<BooleanFormula> args = new ArrayList<BooleanFormula>(pOperands.size());
        for (BooleanFormula arg : pOperands) {
            args.add(this.visitIfNotSeen(arg));
        }
        return args;
    }

    @Override
    public BooleanFormula visitTrue() {
        return this.bfmgr.makeBoolean(true);
    }

    @Override
    public BooleanFormula visitFalse() {
        return this.bfmgr.makeBoolean(false);
    }

    @Override
    public BooleanFormula visitBoundVar(BooleanFormula var, int deBruijnIdx) {
        return var;
    }

    @Override
    public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration decl) {
        return pAtom;
    }

    @Override
    public BooleanFormula visitNot(BooleanFormula pOperand) {
        return this.bfmgr.not(this.visitIfNotSeen(pOperand));
    }

    @Override
    public BooleanFormula visitAnd(List<BooleanFormula> pOperands) {
        return this.bfmgr.and(this.visitIfNotSeen(pOperands));
    }

    @Override
    public BooleanFormula visitOr(List<BooleanFormula> pOperands) {
        return this.bfmgr.or(this.visitIfNotSeen(pOperands));
    }

    @Override
    public BooleanFormula visitXor(BooleanFormula operand1, BooleanFormula operand2) {
        return this.bfmgr.xor(operand1, operand2);
    }

    @Override
    public BooleanFormula visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.equivalence(this.visitIfNotSeen(pOperand1), this.visitIfNotSeen(pOperand2));
    }

    @Override
    public BooleanFormula visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.implication(this.visitIfNotSeen(pOperand1), this.visitIfNotSeen(pOperand2));
    }

    @Override
    public BooleanFormula visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
        return this.bfmgr.ifThenElse(this.visitIfNotSeen(pCondition), this.visitIfNotSeen(pThenFormula), this.visitIfNotSeen(pElseFormula));
    }

    @Override
    public BooleanFormula visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVars, BooleanFormula body) {
        QuantifiedFormulaManager qfmgr = this.manager.getQuantifiedFormulaManager();
        if (quantifier == QuantifiedFormulaManager.Quantifier.FORALL) {
            return qfmgr.forall(new ArrayList(), this.visitIfNotSeen(body));
        }
        return qfmgr.exists(new ArrayList(), this.visitIfNotSeen(body));
    }
}

