/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BasicProverEnvironment;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverInterpolationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllCombinations() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    private <T> InterpolatingProverEnvironment<T> newEnvironmentForTest() {
        return this.context.newProverEnvironmentWithInterpolation();
    }

    @Test
    public <T> void simpleInterpolation() throws Exception {
        this.requireInterpolation();
        try (InterpolatingProverEnvironment<T> prover = this.newEnvironmentForTest();){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
            BooleanFormula f1 = this.imgr.equal(y, this.imgr.multiply(this.imgr.makeNumber(2L), x));
            BooleanFormula f2 = this.imgr.equal(y, this.imgr.add(this.imgr.makeNumber(1L), this.imgr.multiply(z, this.imgr.makeNumber(2L))));
            prover.push(f1);
            T id2 = prover.push(f2);
            boolean check = prover.isUnsat();
            ((BooleanSubject)Truth.assertThat((Boolean)check).named("formulas must be contradicting")).isTrue();
            prover.getInterpolant(Collections.singletonList(id2));
        }
    }

    @Test
    public <T> void binaryInterpolation() throws SolverException, InterruptedException {
        this.requireInterpolation();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        T TA = stack.push(A);
        T TB = stack.push(B);
        T TC = stack.push(C);
        stack.push(D);
        this.assertThatEnvironment(stack).isUnsatisfiable();
        BooleanFormula itpA = stack.getInterpolant(Lists.newArrayList((Object[])new Object[]{TA}));
        BooleanFormula itpB = stack.getInterpolant(Lists.newArrayList((Object[])new Object[]{TA, TB}));
        BooleanFormula itpC = stack.getInterpolant(Lists.newArrayList((Object[])new Object[]{TA, TB, TC}));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, Lists.newArrayList((Object[])new BooleanFormula[]{A, B, C, D}), Lists.newArrayList((Object[])new BooleanFormula[]{itpA, itpB, itpC}));
    }

    private void requireSequentialItp() {
        this.requireInterpolation();
        TruthJUnit.assume().withFailureMessage("Solver does not support sequential interpolation.").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
    }

    private void requireTreeItp() {
        this.requireInterpolation();
        TruthJUnit.assume().withFailureMessage("Solver does not support tree-interpolation.").that((Comparable)((Object)this.solver)).isAnyOf((Object)SolverContextFactory.Solvers.Z3, (Object)SolverContextFactory.Solvers.Z3JAVA, new Object[]{SolverContextFactory.Solvers.SMTINTERPOL});
    }

    @Test
    public <T> void sequentialInterpolation() throws SolverException, InterruptedException {
        this.requireSequentialItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(A)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(B)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(C)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(D)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getSeqInterpolants(Lists.newArrayList((Object[])new Set[]{TA, TB, TC, TD}));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, Lists.newArrayList((Object[])new BooleanFormula[]{A, B, C, D}), itps);
    }

    @Test
    public <T> void treeInterpolation() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula R = this.imgr.equal(b, c);
        BooleanFormula C = this.imgr.equal(c, d);
        BooleanFormula D = this.imgr.equal(d, zero);
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(A)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(B)});
        HashSet TR = Sets.newHashSet((Object[])new Object[]{stack.push(R)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(C)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(D)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants(Lists.newArrayList((Object[])new Set[]{TA, TB, TD, TC, TR}), new int[]{0, 0, 2, 2, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, A, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), B), itps.get(1));
        this.checkImplies(stack, D, itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(2), C), itps.get(3));
        this.checkImplies(stack, this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{itps.get(1), itps.get(3), R})), this.bmgr.makeBoolean(false));
    }

    @Test
    public <T> void treeInterpolation2() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula five = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        NumeralFormula.IntegerFormula e = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula R1 = this.imgr.equal(b, c);
        BooleanFormula C = this.imgr.equal(c, this.imgr.add(d, one));
        BooleanFormula R2 = this.imgr.equal(d, e);
        BooleanFormula D = this.imgr.equal(e, five);
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(A)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(B)});
        HashSet TR1 = Sets.newHashSet((Object[])new Object[]{stack.push(R1)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(C)});
        HashSet TR2 = Sets.newHashSet((Object[])new Object[]{stack.push(R2)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(D)});
        this.assertThatEnvironment(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants(Lists.newArrayList((Object[])new Set[]{TA, TB, TC, TR1, TD, TR2}), new int[]{0, 0, 2, 0, 4, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, A, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), B), itps.get(1));
        this.checkImplies(stack, C, itps.get(2));
        this.checkImplies(stack, this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{itps.get(1), itps.get(2), R1})), itps.get(3));
        this.checkImplies(stack, D, itps.get(4));
        this.checkImplies(stack, this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{itps.get(3), itps.get(4), R2})), this.bmgr.makeBoolean(false));
    }

    private void checkItpSequence(InterpolatingProverEnvironment<?> stack, List<BooleanFormula> formulas, List<BooleanFormula> itps) throws SolverException, InterruptedException {
        assert (formulas.size() - 1 == itps.size()) : "there should be N-1 interpolants for N formulas";
        this.checkImplies(stack, formulas.get(0), itps.get(0));
        for (int i = 1; i < formulas.size() - 1; ++i) {
            this.checkImplies(stack, this.bmgr.and(itps.get(i - 1), formulas.get(i)), itps.get(i));
        }
        this.checkImplies(stack, this.bmgr.and((BooleanFormula)Iterables.getLast(itps), (BooleanFormula)Iterables.getLast(formulas)), this.bmgr.makeBoolean(false));
    }

    private void checkImplies(BasicProverEnvironment<?> stack, BooleanFormula a, BooleanFormula b) throws SolverException, InterruptedException {
        stack.push(this.bmgr.or(this.bmgr.not(a), b));
        this.assertThatEnvironment(stack).isSatisfiable();
        stack.pop();
    }
}

