/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.api.UfDeclaration;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ModelTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testGetSmallIntegers() throws Exception {
        this.testModelGetters((Formula)this.imgr.makeVariable("x"), (Formula)this.imgr.makeNumber(10L), BigInteger.valueOf(10L), "x");
    }

    @Test
    public void testGetNegativeIntegers() throws Exception {
        this.testModelGetters((Formula)this.imgr.makeVariable("x"), (Formula)this.imgr.makeNumber(-10L), BigInteger.valueOf(-10L), "x");
    }

    @Test
    public void testGetLargeIntegers() throws Exception {
        BigInteger large = new BigInteger("1000000000000000000000000000000000000000");
        this.testModelGetters((Formula)this.imgr.makeVariable("x"), (Formula)this.imgr.makeNumber(large), large, "x");
    }

    @Test
    public void testGetSmallIntegralRationals() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        this.testModelGetters((Formula)this.rmgr.makeVariable("x"), (Formula)this.rmgr.makeNumber(1L), Rational.ONE, "x");
    }

    @Test
    public void testGetLargeIntegralRationals() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        BigInteger large = new BigInteger("1000000000000000000000000000000000000000");
        this.testModelGetters((Formula)this.rmgr.makeVariable("x"), (Formula)this.rmgr.makeNumber(large), Rational.ofBigInteger((BigInteger)large), "x");
    }

    @Test
    public void testGetRationals() throws Exception {
        this.requireRationals();
        assert (this.rmgr != null);
        this.testModelGetters((Formula)this.rmgr.makeVariable("x"), (Formula)this.rmgr.makeNumber(Rational.ofString((String)"1/3")), Rational.ofString((String)"1/3"), "x");
    }

    @Test
    public void testGetBooleans() throws Exception {
        this.testModelGetters(this.bmgr.makeVariable("x"), this.bmgr.makeBoolean(true), true, "x");
    }

    @Test
    public void testGetUFs() throws Exception {
        NumeralFormula.IntegerFormula x = this.fmgr.declareAndCallUninterpretedFunction("UF", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("arg")));
        this.testModelGetters(x, (Formula)this.imgr.makeNumber(1L), BigInteger.ONE, "UF");
    }

    @Test
    public void testGetMultipleUFs() throws Exception {
        NumeralFormula.IntegerFormula arg1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("arg1");
        NumeralFormula.IntegerFormula arg2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("arg2");
        UfDeclaration<NumeralFormula.IntegerFormula> declaration = this.fmgr.declareUninterpretedFunction("UF", FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula app1 = this.fmgr.callUninterpretedFunction(declaration, arg1);
        NumeralFormula.IntegerFormula app2 = this.fmgr.callUninterpretedFunction(declaration, arg2);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.imgr.equal(app1, this.imgr.makeNumber(1L)));
            prover.push(this.imgr.equal(app2, this.imgr.makeNumber(2L)));
            prover.push(this.imgr.equal(arg1, this.imgr.makeNumber(3L)));
            prover.push(this.imgr.equal(arg2, this.imgr.makeNumber(4L)));
            this.assertThatEnvironment(prover).isSatisfiable();
            Model m = prover.getModel();
            Truth.assertThat((Comparable)m.evaluate(app1)).isEqualTo((Object)BigInteger.ONE);
            Truth.assertThat((Comparable)m.evaluate(app2)).isEqualTo((Object)BigInteger.valueOf(2L));
            Truth.assertThat((Iterable)m).containsExactly(new Object[]{new Model.ValueAssignment(arg1, "arg1", BigInteger.valueOf(3L), (Collection<?>)ImmutableList.of()), new Model.ValueAssignment(arg1, "arg2", BigInteger.valueOf(4L), (Collection<?>)ImmutableList.of()), new Model.ValueAssignment(this.fmgr.callUninterpretedFunction(declaration, new Formula[]{this.imgr.makeNumber(3L)}), "UF", BigInteger.valueOf(1L), (Collection<?>)ImmutableList.of((Object)BigInteger.valueOf(3L))), new Model.ValueAssignment(this.fmgr.callUninterpretedFunction(declaration, new Formula[]{this.imgr.makeNumber(4L)}), "UF", BigInteger.valueOf(2L), (Collection<?>)ImmutableList.of((Object)BigInteger.valueOf(4L)))});
        }
    }

    @Test
    public void testGetBitvectors() throws Exception {
        this.requireBitvectors();
        assert (this.bvmgr != null);
        this.testModelGetters(this.bvmgr.makeVariable(1, "x"), this.bvmgr.makeBitvector(1, BigInteger.ONE), BigInteger.ONE, "x");
    }

    @Test
    public void testGetArrays() throws Exception {
        this.requireArrays();
        assert (this.amgr != null);
        ArrayFormula array = this.amgr.makeArray("array", FormulaType.IntegerType, FormulaType.IntegerType);
        ArrayFormula updated = this.amgr.store(array, (Formula)this.imgr.makeNumber(1L), (Formula)this.imgr.makeNumber(1L));
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.imgr.equal((NumeralFormula)this.amgr.select(updated, (Formula)this.imgr.makeNumber(1L)), this.imgr.makeNumber(1L)));
            this.assertThatEnvironment(prover).isSatisfiable();
            Model m = prover.getModel();
            for (Model.ValueAssignment valueAssignment : m) {
            }
            Truth.assertThat((Comparable)m.evaluate((NumeralFormula.IntegerFormula)this.amgr.select(updated, (Formula)this.imgr.makeNumber(1L)))).isEqualTo((Object)BigInteger.ONE);
        }
    }

    private void testModelGetters(Formula variable, Formula value, Object expectedValue, String varName) throws Exception {
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.push(this.mgr.makeEqual(value, variable));
            this.assertThatEnvironment(prover).isSatisfiable();
            Model m = prover.getModel();
            Truth.assertThat((Object)m.evaluate(variable)).isEqualTo(expectedValue);
            boolean found = false;
            for (Model.ValueAssignment assignment : m) {
                if (!assignment.getName().equals(varName)) continue;
                found = true;
                Truth.assertThat((Object)assignment.getValue()).isEqualTo(expectedValue);
            }
            Truth.assertThat((Boolean)found).isTrue();
        }
    }
}

