/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;

public class HoudiniApp {
    private final FormulaManager fmgr;
    private final BooleanFormulaManager bfmgr;
    private final SolverContext context;

    public HoudiniApp(String[] args) throws InvalidConfigurationException {
        Configuration config = Configuration.fromCmdLineArguments((String[])args);
        BasicLogManager logger = new BasicLogManager(config);
        ShutdownNotifier notifier = ShutdownManager.create().getNotifier();
        this.context = SolverContextFactory.createSolverContext(config, (LogManager)logger, notifier);
        this.fmgr = this.context.getFormulaManager();
        this.bfmgr = this.context.getFormulaManager().getBooleanFormulaManager();
    }

    public List<BooleanFormula> testHoudini(List<BooleanFormula> lemmas, BooleanFormula transition) throws SolverException, InterruptedException {
        ArrayList<BooleanFormula> annotated = new ArrayList<BooleanFormula>();
        ArrayList<BooleanFormula> annotatedPrimes = new ArrayList<BooleanFormula>();
        HashMap<Integer, BooleanFormula> indexed = new HashMap<Integer, BooleanFormula>();
        for (int i = 0; i < lemmas.size(); ++i) {
            BooleanFormula lemma = lemmas.get(i);
            BooleanFormula primed = this.prime(lemma);
            annotated.add(this.bfmgr.or(this.getSelectorVar(i), lemma));
            annotatedPrimes.add(this.bfmgr.or(this.getSelectorVar(i), primed));
            indexed.put(i, lemma);
        }
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            prover.addConstraint(transition);
            prover.addConstraint(this.bfmgr.and(annotated));
            prover.addConstraint(this.bfmgr.not(this.bfmgr.and(annotatedPrimes)));
            while (!prover.isUnsat()) {
                Model m = prover.getModel();
                int i = 0;
                for (BooleanFormula prime : annotatedPrimes) {
                    if (!m.evaluate(prime).booleanValue()) {
                        prover.addConstraint(this.getSelectorVar(i));
                        indexed.remove(i);
                    }
                    ++i;
                }
            }
        }
        return new ArrayList<BooleanFormula>(indexed.values());
    }

    private BooleanFormula getSelectorVar(int idx) {
        return this.bfmgr.makeVariable("SEL_" + idx);
    }

    private BooleanFormula prime(BooleanFormula input) {
        return this.fmgr.transformRecursively(new FormulaTransformationVisitor(this.fmgr){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return HoudiniApp.this.fmgr.makeVariable(HoudiniApp.this.fmgr.getFormulaType(f), name + "'");
            }
        }, input);
    }
}

