/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolModel;

class SmtInterpolInterpolatingProver
implements InterpolatingProverEnvironment<String> {
    protected final SmtInterpolFormulaManager mgr;
    private final SmtInterpolEnvironment env;
    private final List<String> assertedFormulas;
    private final Map<String, Term> annotatedTerms;
    private boolean closed = false;
    private static final String PREFIX = "term_";
    private static final UniqueIdGenerator termIdGenerator = new UniqueIdGenerator();

    SmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr) {
        this.mgr = pMgr;
        this.env = this.mgr.createEnvironment();
        this.assertedFormulas = new ArrayList<String>();
        this.annotatedTerms = new HashMap<String, Term>();
    }

    @Override
    public String push(BooleanFormula f) {
        this.push();
        return this.addConstraint(f);
    }

    protected void pushAndAssert(Term annotatedTerm) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.push();
        this.env.assertTerm(annotatedTerm);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        String removed = this.assertedFormulas.remove(this.assertedFormulas.size() - 1);
        this.annotatedTerms.remove(removed);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        this.env.pop(1);
    }

    @Override
    public String addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        String termName = SmtInterpolInterpolatingProver.generateTermName();
        Term t = (Term)this.mgr.extractInfo(f);
        Term annotatedTerm = this.env.annotate(t, new Annotation(":named", (Object)termName));
        this.env.assertTerm(annotatedTerm);
        this.assertedFormulas.add(termName);
        this.annotatedTerms.put(termName, t);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        return termName;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.env.push(1);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !this.env.checkSat();
    }

    @Override
    public BooleanFormula getInterpolant(List<String> pTermNamesOfA) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        HashSet<String> termNamesOfA = new HashSet<String>(pTermNamesOfA);
        ImmutableSet termNamesOfB = FluentIterable.from(this.assertedFormulas).filter(Predicates.not((Predicate)Predicates.in(termNamesOfA))).toSet();
        Term termA = this.buildConjunctionOfNamedTerms(termNamesOfA);
        Term termB = this.buildConjunctionOfNamedTerms((Set<String>)termNamesOfB);
        return this.getInterpolant(termA, termB);
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<String>> partitionedTermNames) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        Term[] itps = this.env.getInterpolants(formulas);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<String>> partitionedTermNames, int[] startOfSubTree) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term[] formulas = new Term[partitionedTermNames.size()];
        for (int i = 0; i < formulas.length; ++i) {
            formulas[i] = this.buildConjunctionOfNamedTerms(partitionedTermNames.get(i));
        }
        assert (SmtInterpolInterpolatingProver.checkSubTrees(partitionedTermNames, startOfSubTree));
        Term[] itps = this.env.getTreeInterpolants(formulas, startOfSubTree);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (Term itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula(itp));
        }
        return result;
    }

    private static boolean checkSubTrees(List<Set<String>> partitionedTermNames, int[] startOfSubTree) {
        for (int i = 0; i < partitionedTermNames.size(); ++i) {
            if (startOfSubTree[i] < 0) {
                throw new AssertionError((Object)"subtree array must not contain negative element");
            }
            int j = i;
            while (startOfSubTree[i] < j) {
                j = startOfSubTree[j - 1];
            }
            if (startOfSubTree[i] != j) {
                throw new AssertionError((Object)"malformed subtree array.");
            }
        }
        if (startOfSubTree[partitionedTermNames.size() - 1] != 0) {
            throw new AssertionError((Object)"malformed subtree array.");
        }
        return true;
    }

    protected BooleanFormula getInterpolant(Term termA, Term termB) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term[] itp = this.env.getInterpolants(new Term[]{termA, termB});
        assert (itp.length == 1);
        return this.mgr.encapsulateBooleanFormula(itp[0]);
    }

    private Term buildConjunctionOfNamedTerms(Set<String> termNames) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term[] terms = new Term[termNames.size()];
        int i = 0;
        for (String termName : termNames) {
            terms[i] = this.env.term(termName, new Term[0]);
            ++i;
        }
        if (terms.length > 1) {
            return this.env.term("and", terms);
        }
        assert (terms.length != 0);
        return terms[0];
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        if (!this.assertedFormulas.isEmpty()) {
            this.env.pop(this.assertedFormulas.size());
            this.assertedFormulas.clear();
            this.annotatedTerms.clear();
        }
        this.closed = true;
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        return new SmtInterpolModel(this.env.getModel(), this.mgr.getFormulaCreator(), this.annotatedTerms.values());
    }

    private static String generateTermName() {
        return PREFIX + termIdGenerator.getFreshId();
    }
}

