/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.smtinterpol.FormulaCollectionScript;
import org.sosy_lab.solver.smtinterpol.LoggingSmtInterpolInterpolatingProver;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolInterpolatingProver;

@Options(deprecatedPrefix="cpa.predicate.solver.smtinterpol", prefix="solver.smtinterpol")
class SmtInterpolEnvironment {
    @Option(secure=true, description="Double check generated results like interpolants and models whether they are correct")
    private boolean checkResults = false;
    @Nullable
    private final PathCounterTemplate smtLogfile;
    @Option(secure=true, description="Further options that will be set to true for SMTInterpol in addition to the default options. Format is 'option1,option2,option3'")
    private List<String> furtherOptions = ImmutableList.of();
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Script script;
    private final Theory theory;
    private int stackDepth = 0;

    SmtInterpolEnvironment(Configuration config, LogManager pLogger, final ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate pSmtLogfile, long randomSeed) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.smtLogfile = pSmtLogfile;
        SMTInterpol smtInterpol = new SMTInterpol(SmtInterpolEnvironment.createLog4jLogger(this.logger), new TerminationRequest(){

            public boolean isTerminationRequested() {
                return pShutdownNotifier.shouldShutdown();
            }
        });
        this.script = this.smtLogfile != null ? this.createLoggingWrapper(smtInterpol) : smtInterpol;
        try {
            this.script.setOption(":random-seed", (Object)randomSeed);
            this.script.setOption(":produce-interpolants", (Object)true);
            this.script.setOption(":produce-models", (Object)true);
            this.script.setOption(":produce-unsat-cores", (Object)true);
            if (this.checkResults) {
                this.script.setOption(":interpolant-check-mode", (Object)true);
                this.script.setOption(":unsat-core-check-mode", (Object)true);
                this.script.setOption(":model-check-mode", (Object)true);
            }
            this.script.setLogic(Logics.QF_AUFLIRA);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
        for (String option : this.furtherOptions) {
            try {
                this.script.setOption(":" + option, (Object)true);
            }
            catch (SMTLIBException | UnsupportedOperationException e) {
                throw new InvalidConfigurationException("Invalid option \"" + option + "\" for SMTInterpol.", e);
            }
        }
        this.theory = smtInterpol.getTheory();
    }

    private Script createLoggingWrapper(SMTInterpol smtInterpol) {
        assert (this.smtLogfile != null);
        String filename = this.smtLogfile.getFreshPath().toAbsolutePath().toString();
        try {
            return new LoggingScript((Script)smtInterpol, filename, true, true);
        }
        catch (FileNotFoundException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not open log file for SMTInterpol queries");
            return smtInterpol;
        }
    }

    private static Logger createLog4jLogger(final LogManager ourLogger) {
        Logger logger = Logger.getLogger((String)"SMTInterpol");
        logger.setLevel(org.apache.log4j.Level.ERROR);
        logger.addAppender((Appender)new AppenderSkeleton(){

            public boolean requiresLayout() {
                return false;
            }

            public void close() {
            }

            protected void append(LoggingEvent pArg0) {
                ThrowableInformation throwable = pArg0.getThrowableInformation();
                if (throwable != null) {
                    Throwables.propagateIfPossible((Throwable)throwable.getThrowable());
                }
                ourLogger.log(Level.SEVERE, new Object[]{pArg0.getLoggerName(), pArg0.getLevel(), "output:", pArg0.getRenderedMessage()});
                if (throwable != null) {
                    ourLogger.logException(Level.SEVERE, throwable.getThrowable(), pArg0.getLoggerName() + " exception");
                }
            }
        });
        return logger;
    }

    Theory getTheory() {
        return this.theory;
    }

    SmtInterpolInterpolatingProver getInterpolator(SmtInterpolFormulaManager mgr) {
        if (this.smtLogfile != null) {
            Path logfile = this.smtLogfile.getFreshPath();
            try {
                PrintWriter out = new PrintWriter(Files.openOutputFile((Path)logfile, (FileWriteMode[])new FileWriteMode[0]));
                out.println("(set-option :random-seed " + this.script.getOption(":random-seed") + ")");
                out.println("(set-option :produce-interpolants true)");
                out.println("(set-option :produce-models true)");
                out.println("(set-option :produce-unsat-cores true)");
                if (this.checkResults) {
                    out.println("(set-option :interpolant-check-mode true)");
                    out.println("(set-option :unsat-core-check-mode true)");
                    out.println("(set-option :model-check-mode true)");
                }
                out.println("(set-logic " + this.theory.getLogic().name() + ")");
                return new LoggingSmtInterpolInterpolatingProver(mgr, out);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write interpolation query to file");
            }
        }
        return new SmtInterpolInterpolatingProver(mgr);
    }

    int getStackDepth() {
        return this.stackDepth;
    }

    public List<Term> parseStringToTerms(String s) {
        FormulaCollectionScript parseScript = new FormulaCollectionScript(this.script, this.theory);
        ParseEnvironment parseEnv = new ParseEnvironment(parseScript){

            public void printError(String pMessage) {
                throw new SMTLIBException(pMessage);
            }

            public void printSuccess() {
            }
        };
        try {
            parseEnv.parseStream((Reader)new StringReader(s), "<stdin>");
        }
        catch (SMTLIBException e) {
            throw new IllegalArgumentException("Could not parse term:" + e.getMessage(), e);
        }
        return parseScript.getAssertedTerms();
    }

    public void setOption(String opt, Object value) {
        try {
            this.script.setOption(opt, value);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) {
        FunctionSymbol fsym = this.theory.getFunction(fun, paramSorts);
        if (fsym == null) {
            this.script.declareFun(fun, paramSorts, resultSort);
        } else if (!fsym.getReturnSort().equals(resultSort)) {
            throw new SMTLIBException("Function " + fun + " is already declared with different definition");
        }
    }

    public void push(int levels) {
        Preconditions.checkArgument((levels > 0 ? 1 : 0) != 0);
        try {
            this.script.push(levels);
            this.stackDepth += levels;
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void pop(int levels) {
        Preconditions.checkArgument((levels >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.stackDepth >= levels ? 1 : 0) != 0, (Object)"not enough levels to remove");
        try {
            this.script.pop(levels);
            this.stackDepth -= levels;
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void assertTerm(Term term) {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"assertions should be on higher levels");
        try {
            this.script.assertTerm(term);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean checkSat() throws InterruptedException {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"checkSat should be on higher levels");
        try {
            this.shutdownNotifier.shutdownIfNecessary();
            Script.LBool result = this.script.checkSat();
            switch (result) {
                case SAT: {
                    return true;
                }
                case UNSAT: {
                    return false;
                }
                case UNKNOWN: {
                    Object reason = this.script.getInfo(":reason-unknown");
                    if (!(reason instanceof ReasonUnknown)) {
                        throw new SMTLIBException("checkSat returned UNKNOWN with unknown reason " + reason);
                    }
                    switch ((ReasonUnknown)reason) {
                        case MEMOUT: {
                            throw new OutOfMemoryError("Out of memory during SMTInterpol operation");
                        }
                        case CANCELLED: {
                            this.shutdownNotifier.shutdownIfNecessary();
                            throw new SMTLIBException("checkSat returned UNKNOWN with unexpected reason " + reason);
                        }
                    }
                    throw new SMTLIBException("checkSat returned UNKNOWN with unexpected reason " + reason);
                }
            }
            throw new SMTLIBException("checkSat returned " + result);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Iterable<Term[]> checkAllSat(Term[] importantPredicates) throws InterruptedException {
        try {
            this.shutdownNotifier.shutdownIfNecessary();
            return this.script.checkAllsat(importantPredicates);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Model getModel() {
        return this.script.getModel();
    }

    public Object getInfo(String info) {
        return this.script.getInfo(info);
    }

    public Sort getBooleanSort() {
        return this.theory.getBooleanSort();
    }

    public Sort getIntegerSort() {
        return this.theory.getNumericSort();
    }

    public Sort getRealSort() {
        return this.theory.getRealSort();
    }

    Sort sort(String sortname, Sort ... params) {
        try {
            return this.script.sort(sortname, params);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term term(String funcname, Term ... params) {
        try {
            return this.script.term(funcname, params);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term term(String funcname, BigInteger[] indices, @Nullable Sort returnSort, Term ... params) {
        try {
            return this.script.term(funcname, indices, returnSort, params);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public TermVariable variable(String varname, Sort sort) {
        try {
            return this.script.variable(varname, sort);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) {
        try {
            return this.script.quantifier(quantor, vars, body, patterns);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term let(TermVariable[] pVars, Term[] pValues, Term pBody) {
        try {
            return this.script.let(pVars, pValues, pBody);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term annotate(Term t, Annotation ... annotations) {
        try {
            return this.script.annotate(t, annotations);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term numeral(BigInteger num) {
        try {
            return this.script.numeral(num);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term numeral(String num) {
        try {
            return this.script.numeral(num);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term decimal(String num) {
        try {
            return this.script.decimal(num);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term decimal(BigDecimal num) {
        try {
            return this.script.decimal(num);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term hexadecimal(String hex) {
        try {
            return this.script.hexadecimal(hex);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term binary(String bin) {
        try {
            return this.script.binary(bin);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term[] getInterpolants(Term[] partition) throws SolverException, InterruptedException {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"interpolants should be on higher levels");
        try {
            return this.script.getInterpolants(partition);
        }
        catch (UnsupportedOperationException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Cannot interpolate ")) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
        catch (SMTLIBException e) {
            if ("Timeout exceeded".equals(e.getMessage())) {
                this.shutdownNotifier.shutdownIfNecessary();
            }
            throw new AssertionError((Object)e);
        }
    }

    public Term[] getTreeInterpolants(Term[] partition, int[] startOfSubTree) throws SolverException, InterruptedException {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"interpolants should be on higher levels");
        try {
            return this.script.getInterpolants(partition, startOfSubTree);
        }
        catch (UnsupportedOperationException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Cannot interpolate ")) {
                throw new SolverException(e.getMessage(), e);
            }
            throw e;
        }
        catch (SMTLIBException e) {
            if ("Timeout exceeded".equals(e.getMessage())) {
                this.shutdownNotifier.shutdownIfNecessary();
            }
            throw new AssertionError((Object)e);
        }
    }

    public Term[] getUnsatCore() {
        Preconditions.checkState((this.stackDepth > 0 ? 1 : 0) != 0, (Object)"unsat core should be on higher levels");
        try {
            return this.script.getUnsatCore();
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Term simplify(Term input) {
        try {
            SimplifyDDA s = new SimplifyDDA(this.script, true);
            return s.getSimplifiedTerm(input);
        }
        catch (SMTLIBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getVersion() {
        QuotedObject program = (QuotedObject)this.script.getInfo(":name");
        QuotedObject version = (QuotedObject)this.script.getInfo(":version");
        return program.getValue() + " " + version.getValue();
    }
}

