/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.OptimizationProverEnvironment;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractSolverContext;
import org.sosy_lab.solver.princess.PrincessArrayFormulaManager;
import org.sosy_lab.solver.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.princess.PrincessFormulaManager;
import org.sosy_lab.solver.princess.PrincessFunctionFormulaManager;
import org.sosy_lab.solver.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.solver.princess.PrincessInterpolatingProver;
import org.sosy_lab.solver.princess.PrincessQuantifiedFormulaManager;
import org.sosy_lab.solver.princess.PrincessTermType;
import org.sosy_lab.solver.princess.PrincessTheoremProver;

public final class PrincessSolverContext
extends AbstractSolverContext {
    private final ShutdownNotifier shutdownNotifier;
    private final PrincessFormulaManager manager;
    private final PrincessFormulaCreator creator;

    private PrincessSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier, PrincessFormulaManager manager, PrincessFormulaCreator creator) throws InvalidConfigurationException {
        super(config, logger, manager);
        this.shutdownNotifier = shutdownNotifier;
        this.manager = manager;
        this.creator = creator;
    }

    public static SolverContext create(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, @Nullable PathCounterTemplate pLogfileTemplate) throws InvalidConfigurationException {
        PrincessOptions options = new PrincessOptions(config);
        PrincessEnvironment env = new PrincessEnvironment(pLogfileTemplate, pShutdownNotifier, options);
        PrincessFormulaCreator creator = new PrincessFormulaCreator(env, PrincessTermType.Boolean, PrincessTermType.Integer);
        PrincessFunctionFormulaManager functionTheory = new PrincessFunctionFormulaManager(creator);
        PrincessBooleanFormulaManager booleanTheory = new PrincessBooleanFormulaManager(creator);
        PrincessIntegerFormulaManager integerTheory = new PrincessIntegerFormulaManager(creator);
        PrincessArrayFormulaManager arrayTheory = new PrincessArrayFormulaManager(creator);
        PrincessQuantifiedFormulaManager quantifierTheory = new PrincessQuantifiedFormulaManager(creator);
        PrincessFormulaManager manager = new PrincessFormulaManager(creator, functionTheory, booleanTheory, integerTheory, arrayTheory, quantifierTheory);
        return new PrincessSolverContext(config, logger, pShutdownNotifier, manager, creator);
    }

    @Override
    public FormulaManager getFormulaManager() {
        return this.manager;
    }

    @Override
    public ProverEnvironment newProverEnvironment0(SolverContext.ProverOptions ... options) {
        return new PrincessTheoremProver(this.manager, this.shutdownNotifier, this.creator);
    }

    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0() {
        return new PrincessInterpolatingProver(this.manager, this.creator);
    }

    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment() {
        throw new UnsupportedOperationException("Princess does not support optimization");
    }

    @Override
    public String getVersion() {
        return ((PrincessEnvironment)this.creator.getEnv()).getVersion();
    }

    @Override
    public void close() {
    }

    @Options(prefix="solver.princess")
    static class PrincessOptions {
        @Option(secure=true, description="The number of atoms a term has to have before it gets abbreviated if there are more identical terms.")
        private int minAtomsForAbbreviation = 100;

        PrincessOptions(Configuration config) throws InvalidConfigurationException {
            config.inject((Object)this);
        }

        public int getMinAtomsForAbbreviation() {
            return this.minAtomsForAbbreviation;
        }
    }
}

