/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IConstant;
import ap.parser.IEpsilon;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFormulaITE;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntFormula;
import ap.parser.IIntLit;
import ap.parser.IIntRelation;
import ap.parser.INot;
import ap.parser.IPlus;
import ap.parser.IQuantified;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.parser.ITimes;
import ap.parser.IVariable;
import ap.terfor.conjunctions.Quantifier;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessTermType;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import scala.Enumeration;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

class PrincessFormulaCreator
extends FormulaCreator<IExpression, PrincessTermType, PrincessEnvironment> {
    PrincessFormulaCreator(PrincessEnvironment pEnv, PrincessTermType pBoolType, PrincessTermType pIntegerType) {
        super(pEnv, pBoolType, pIntegerType, null);
    }

    @Override
    public FormulaType<?> getFormulaType(IExpression pFormula) {
        if (((PrincessEnvironment)this.getEnv()).hasArrayType(pFormula)) {
            return new FormulaType.ArrayFormulaType<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>(FormulaType.IntegerType, FormulaType.IntegerType);
        }
        if (pFormula instanceof IFormula) {
            return FormulaType.BooleanType;
        }
        if (pFormula instanceof ITerm) {
            return FormulaType.IntegerType;
        }
        throw new IllegalArgumentException("Unknown formula type");
    }

    @Override
    public IExpression makeVariable(PrincessTermType type, String varName) {
        return ((PrincessEnvironment)this.getEnv()).makeVariable(type, varName);
    }

    @Override
    public PrincessTermType getBitvectorType(int pBitwidth) {
        throw new UnsupportedOperationException("Bitvector theory is not supported by Princess");
    }

    @Override
    public PrincessTermType getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by Princess");
    }

    @Override
    public PrincessTermType getArrayType(PrincessTermType pIndexType, PrincessTermType pElementType) {
        return PrincessTermType.Array;
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return new FormulaType.ArrayFormulaType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    private String getName(IExpression input) {
        if (input instanceof IAtom || input instanceof IConstant) {
            return input.toString();
        }
        if (input instanceof IBinFormula) {
            return ((IBinFormula)input).j().toString();
        }
        if (input instanceof IFormulaITE || input instanceof ITermITE) {
            return "ite";
        }
        if (input instanceof IIntFormula) {
            return ((IIntFormula)input).rel().toString();
        }
        if (input instanceof INot) {
            return "not";
        }
        if (input instanceof IFunApp) {
            return ((IFunApp)input).fun().name();
        }
        if (input instanceof IPlus) {
            return "+";
        }
        if (input instanceof ITimes) {
            return "*";
        }
        if (input instanceof IEpsilon) {
            return "eps";
        }
        throw new AssertionError((Object)("Unhandled type " + input.getClass()));
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula f, final IExpression input) {
        if (input instanceof IIntLit) {
            IdealInt value = ((IIntLit)input).value();
            return visitor.visitConstant(f, value.bigIntValue());
        }
        if (input instanceof IBoolLit) {
            IBoolLit literal = (IBoolLit)input;
            return visitor.visitConstant(f, literal.value());
        }
        if (input instanceof IQuantified) {
            BooleanFormula body = this.encapsulateBoolean(((IQuantified)input).subformula());
            return visitor.visitQuantifier((BooleanFormula)f, ((IQuantified)input).quan().equals(Quantifier.apply((boolean)true)) ? QuantifiedFormulaManager.Quantifier.FORALL : QuantifiedFormulaManager.Quantifier.EXISTS, new ArrayList<Formula>(), body);
        }
        if (input instanceof IVariable) {
            return visitor.visitBoundVariable(f, ((IVariable)input).index());
        }
        if (input instanceof IAtom || input instanceof IConstant) {
            return visitor.visitFreeVariable(f, input.toString());
        }
        int arity = input.length();
        ArrayList<Formula> args = new ArrayList<Formula>(arity);
        for (int i = 0; i < arity; ++i) {
            IExpression arg = input.apply(i);
            FormulaType<IExpression> argumentType = this.getFormulaType((Formula)arg);
            args.add((Formula)this.encapsulate(argumentType, arg));
        }
        Function<List<Formula>, Formula> constructor = new Function<List<Formula>, Formula>(){

            public Formula apply(List<Formula> formulas) {
                return PrincessFormulaCreator.this.encapsulateWithTypeOf(input.update((Seq)JavaConversions.asScalaBuffer((List)PrincessFormulaCreator.this.extractInfo(formulas))));
            }
        };
        return visitor.visitFunction(f, args, FunctionDeclaration.of(this.getName(input), this.getDeclarationKind(input)), constructor);
    }

    private FunctionDeclarationKind getDeclarationKind(IExpression input) {
        assert (!(input instanceof IAtom) && !(input instanceof IConstant)) : "Variables should be handled somewhere else";
        if (input instanceof IFormulaITE || input instanceof ITermITE) {
            return FunctionDeclarationKind.ITE;
        }
        if (input instanceof IFunApp) {
            if (((IFunApp)input).fun().name().equals("select")) {
                return FunctionDeclarationKind.SELECT;
            }
            if (((IFunApp)input).fun().name().equals("store")) {
                return FunctionDeclarationKind.STORE;
            }
            return FunctionDeclarationKind.UF;
        }
        if (PrincessFormulaCreator.isBinaryFunction(input, IBinJunctor.And())) {
            return FunctionDeclarationKind.AND;
        }
        if (PrincessFormulaCreator.isBinaryFunction(input, IBinJunctor.Or())) {
            return FunctionDeclarationKind.OR;
        }
        if (input instanceof INot) {
            return FunctionDeclarationKind.NOT;
        }
        if (PrincessFormulaCreator.isBinaryFunction(input, IBinJunctor.Eqv())) {
            return FunctionDeclarationKind.IFF;
        }
        if (input instanceof ITimes) {
            return FunctionDeclarationKind.MUL;
        }
        if (input instanceof IPlus) {
            return FunctionDeclarationKind.ADD;
        }
        if (input instanceof IIntFormula) {
            IIntFormula f = (IIntFormula)input;
            if (f.rel().equals((Object)IIntRelation.EqZero())) {
                return FunctionDeclarationKind.EQ;
            }
            if (f.rel().equals((Object)IIntRelation.GeqZero())) {
                return FunctionDeclarationKind.GTE;
            }
            throw new AssertionError((Object)"Unhandled value for integer relation");
        }
        return FunctionDeclarationKind.OTHER;
    }

    private static boolean isBinaryFunction(IExpression t, Enumeration.Value val) {
        return t instanceof IBinFormula && val == ((IBinFormula)t).j();
    }

    public IExpression makeFunction(IFunction funcDecl, List<IExpression> args) {
        Preconditions.checkArgument((args.size() == funcDecl.arity() ? 1 : 0) != 0, (Object)"functiontype has different number of args.");
        ArrayBuffer argsBuf = new ArrayBuffer();
        for (IExpression arg : args) {
            Object termArg = arg instanceof IFormula ? new ITermITE((IFormula)arg, (ITerm)new IIntLit(IdealInt.ZERO()), (ITerm)new IIntLit(IdealInt.ONE())) : (ITerm)arg;
            argsBuf.$plus$eq(termArg);
        }
        IFunApp returnFormula = new IFunApp(funcDecl, argsBuf.toSeq());
        PrincessTermType returnType = ((PrincessEnvironment)this.environment).getReturnTypeForFunction(funcDecl);
        if (returnType == PrincessTermType.Boolean) {
            IExpression.BooleanFunApplier ap = new IExpression.BooleanFunApplier(funcDecl);
            return ap.apply((Seq)argsBuf);
        }
        if (returnType == PrincessTermType.Integer) {
            return returnFormula;
        }
        throw new AssertionError((Object)"Not possible to have return types for functions other than bool or int.");
    }
}

