/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import java.math.BigDecimal;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.RationalFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.mathsat5.Mathsat5NumeralFormulaManager;

class Mathsat5RationalFormulaManager
extends Mathsat5NumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula>
implements RationalFormulaManager {
    Mathsat5RationalFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
    }

    @Override
    protected long getNumeralType() {
        return (Long)this.getFormulaCreator().getRationalType();
    }

    @Override
    public FormulaType<NumeralFormula.RationalFormula> getFormulaType() {
        return FormulaType.RationalType;
    }

    @Override
    protected Long makeNumberImpl(double pNumber) {
        return this.makeNumberImpl(Double.toString(pNumber));
    }

    @Override
    protected Long makeNumberImpl(BigDecimal pNumber) {
        return this.makeNumberImpl(pNumber.toPlainString());
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        String[] frac;
        if (!this.isNumeral(pNumber2)) {
            return super.divide(pNumber1, pNumber2);
        }
        long mathsatEnv = (Long)this.getFormulaCreator().getEnv();
        long t1 = pNumber1;
        long t2 = pNumber2;
        String n = Mathsat5NativeApi.msat_term_repr(t2);
        if (n.startsWith("(")) {
            n = n.substring(1, n.length() - 1);
        }
        if ((frac = n.split("/")).length == 1) {
            n = "1/" + n;
        } else {
            assert (frac.length == 2);
            n = frac[1] + "/" + frac[0];
        }
        t2 = Mathsat5NativeApi.msat_make_number(mathsatEnv, n);
        return Mathsat5NativeApi.msat_make_times(mathsatEnv, t2, t1);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return Mathsat5NativeApi.msat_make_true((Long)this.getFormulaCreator().getEnv());
    }
}

