/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import java.math.BigInteger;
import org.sosy_lab.solver.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;

class Mathsat5BitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Long, Long, Long> {
    private final long mathsatEnv;

    protected Mathsat5BitvectorFormulaManager(Mathsat5FormulaCreator pCreator) {
        super(pCreator);
        this.mathsatEnv = (Long)pCreator.getEnv();
    }

    public static Mathsat5BitvectorFormulaManager create(Mathsat5FormulaCreator creator) {
        return new Mathsat5BitvectorFormulaManager(creator);
    }

    @Override
    public Long concat(Long pFirst, Long pSecond) {
        return Mathsat5NativeApi.msat_make_bv_concat(this.mathsatEnv, pFirst, pSecond);
    }

    @Override
    public Long extract(Long pFirst, int pMsb, int pLsb, boolean pSigned) {
        return Mathsat5NativeApi.msat_make_bv_extract(this.mathsatEnv, pMsb, pLsb, pFirst);
    }

    @Override
    public Long extend(Long pNumber, int pExtensionBits, boolean pSigned) {
        if (pSigned) {
            return Mathsat5NativeApi.msat_make_bv_sext(this.mathsatEnv, pExtensionBits, pNumber);
        }
        return Mathsat5NativeApi.msat_make_bv_zext(this.mathsatEnv, pExtensionBits, pNumber);
    }

    @Override
    public Long makeBitvectorImpl(int pLength, long pI) {
        return this.makeBitvectorImpl(pLength, BigInteger.valueOf(pI));
    }

    @Override
    public Long makeBitvectorImpl(int pLength, BigInteger pI) {
        if (pI.signum() < 0) {
            BigInteger max = BigInteger.valueOf(2L).pow(pLength - 1);
            if (pI.compareTo(max.negate()) < 0) {
                throw new IllegalArgumentException(pI + " is to small for a bitvector with length " + pLength);
            }
            BigInteger n = BigInteger.valueOf(2L).pow(pLength);
            pI = pI.add(n);
        }
        return Mathsat5NativeApi.msat_make_bv_number(this.mathsatEnv, pI.toString(), pLength, 10);
    }

    @Override
    public Long makeVariableImpl(int length, String var) {
        long bvType = (Long)this.getFormulaCreator().getBitvectorType(length);
        return (Long)this.getFormulaCreator().makeVariable(bvType, var);
    }

    @Override
    public Long shiftRight(Long number, Long toShift, boolean signed) {
        long t = signed ? Mathsat5NativeApi.msat_make_bv_ashr(this.mathsatEnv, number, toShift) : Mathsat5NativeApi.msat_make_bv_lshr(this.mathsatEnv, number, toShift);
        return t;
    }

    @Override
    public Long shiftLeft(Long number, Long toShift) {
        return Mathsat5NativeApi.msat_make_bv_lshl(this.mathsatEnv, number, toShift);
    }

    @Override
    public Long not(Long pBits) {
        return Mathsat5NativeApi.msat_make_bv_not(this.mathsatEnv, pBits);
    }

    @Override
    public Long and(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_bv_and(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long or(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_bv_or(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long xor(Long pBits1, Long pBits2) {
        return Mathsat5NativeApi.msat_make_bv_xor(this.mathsatEnv, pBits1, pBits2);
    }

    @Override
    public Long negate(Long pNumber) {
        return Mathsat5NativeApi.msat_make_bv_neg(this.mathsatEnv, pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_bv_plus(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_bv_minus(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_sdiv(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_udiv(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long modulo(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_srem(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_urem(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return Mathsat5NativeApi.msat_make_true(this.mathsatEnv);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_bv_times(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Mathsat5NativeApi.msat_make_equal(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_slt(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_ult(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Mathsat5NativeApi.msat_make_bv_sleq(this.mathsatEnv, pNumber1, pNumber2);
        }
        return Mathsat5NativeApi.msat_make_bv_uleq(this.mathsatEnv, pNumber1, pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessThan(pNumber2, pNumber1, signed);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessOrEquals(pNumber2, pNumber1, signed);
    }
}

