/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.tactics;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.visitors.BooleanFormulaTransformationVisitor;

class NNFVisitor
extends BooleanFormulaTransformationVisitor {
    private final NNFInsideNotVisitor insideNotVisitor;
    private final BooleanFormulaManager bfmgr;

    NNFVisitor(FormulaManager pFmgr) {
        super(pFmgr, Maps.newHashMap());
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.insideNotVisitor = new NNFInsideNotVisitor(pFmgr, new HashMap<BooleanFormula, BooleanFormula>());
    }

    @Override
    public BooleanFormula visitNot(BooleanFormula pOperand) {
        return this.bfmgr.visit(this.insideNotVisitor, pOperand);
    }

    @Override
    public BooleanFormula visitXor(BooleanFormula operand1, BooleanFormula operand2) {
        return this.bfmgr.visit(this, this.rewriteXor(operand1, operand2));
    }

    private BooleanFormula rewriteXor(BooleanFormula operand1, BooleanFormula operand2) {
        return this.bfmgr.or(this.bfmgr.and(operand1, this.bfmgr.not(operand2)), this.bfmgr.and(this.bfmgr.not(operand1), operand2));
    }

    @Override
    public BooleanFormula visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.visit(this, this.rewriteEquivalence(pOperand1, pOperand2));
    }

    private BooleanFormula rewriteEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.or(this.bfmgr.and(pOperand1, pOperand2), this.bfmgr.and(this.bfmgr.not(pOperand1), this.bfmgr.not(pOperand2)));
    }

    @Override
    public BooleanFormula visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.visit(this, this.rewriteImplication(pOperand1, pOperand2));
    }

    private BooleanFormula rewriteImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        return this.bfmgr.or(this.bfmgr.not(pOperand1), pOperand2);
    }

    @Override
    public BooleanFormula visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
        return this.bfmgr.visit(this, this.rewriteIfThenElse(pCondition, pThenFormula, pElseFormula));
    }

    private BooleanFormula rewriteIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
        return this.bfmgr.or(this.bfmgr.and(pCondition, pThenFormula), this.bfmgr.and(this.bfmgr.not(pCondition), pElseFormula));
    }

    private class NNFInsideNotVisitor
    extends BooleanFormulaTransformationVisitor {
        protected NNFInsideNotVisitor(FormulaManager pFmgr, Map<BooleanFormula, BooleanFormula> pCache) {
            super(pFmgr, pCache);
        }

        @Override
        public BooleanFormula visitTrue() {
            return NNFVisitor.this.bfmgr.makeBoolean(false);
        }

        @Override
        public BooleanFormula visitFalse() {
            return NNFVisitor.this.bfmgr.makeBoolean(true);
        }

        @Override
        public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration decl) {
            return NNFVisitor.this.bfmgr.not(pAtom);
        }

        @Override
        public BooleanFormula visitNot(BooleanFormula pOperand) {
            return NNFVisitor.this.bfmgr.visit(NNFVisitor.this, pOperand);
        }

        @Override
        public BooleanFormula visitAnd(List<BooleanFormula> pOperands) {
            ArrayList<BooleanFormula> newOperands = new ArrayList<BooleanFormula>();
            for (BooleanFormula f : pOperands) {
                newOperands.add(NNFVisitor.this.bfmgr.visit(this, f));
            }
            return NNFVisitor.this.bfmgr.or(newOperands);
        }

        @Override
        public BooleanFormula visitOr(List<BooleanFormula> pOperands) {
            ArrayList<BooleanFormula> newOperands = new ArrayList<BooleanFormula>();
            for (BooleanFormula f : pOperands) {
                newOperands.add(NNFVisitor.this.bfmgr.visit(this, f));
            }
            return NNFVisitor.this.bfmgr.and(newOperands);
        }

        @Override
        public BooleanFormula visitXor(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return NNFVisitor.this.bfmgr.visit(this, NNFVisitor.this.rewriteXor(pOperand1, pOperand2));
        }

        @Override
        public BooleanFormula visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return NNFVisitor.this.bfmgr.visit(this, NNFVisitor.this.rewriteEquivalence(pOperand1, pOperand2));
        }

        @Override
        public BooleanFormula visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return NNFVisitor.this.bfmgr.visit(this, NNFVisitor.this.bfmgr.or(NNFVisitor.this.bfmgr.not(pOperand1), pOperand2));
        }

        @Override
        public BooleanFormula visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            return NNFVisitor.this.bfmgr.visit(this, NNFVisitor.this.rewriteIfThenElse(pCondition, pThenFormula, pElseFormula));
        }
    }
}

