/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

final class RecursiveBooleanFormulaVisitor
implements BooleanFormulaVisitor<TraversalProcess> {
    private final Set<BooleanFormula> seen = new HashSet<BooleanFormula>();
    private final Deque<BooleanFormula> toVisit = new ArrayDeque<BooleanFormula>();
    private final BooleanFormulaVisitor<TraversalProcess> delegate;

    RecursiveBooleanFormulaVisitor(BooleanFormulaVisitor<TraversalProcess> pDelegate) {
        this.delegate = (BooleanFormulaVisitor)Preconditions.checkNotNull(pDelegate);
    }

    void addToQueue(BooleanFormula f) {
        if (this.seen.add(f)) {
            this.toVisit.push(f);
        }
    }

    boolean isQueueEmpty() {
        return this.toVisit.isEmpty();
    }

    BooleanFormula pop() {
        return this.toVisit.pop();
    }

    private void addToQueueIfNecessary(TraversalProcess result, BooleanFormula pOperand1, BooleanFormula pOperand2) {
        if (result == TraversalProcess.CONTINUE) {
            this.addToQueue(pOperand1);
            this.addToQueue(pOperand2);
        }
    }

    private void addToQueueIfNecessary(TraversalProcess result, List<BooleanFormula> pOperands) {
        if (result == TraversalProcess.CONTINUE) {
            for (BooleanFormula operand : pOperands) {
                this.addToQueue(operand);
            }
        }
    }

    @Override
    public TraversalProcess visitTrue() {
        return this.delegate.visitTrue();
    }

    @Override
    public TraversalProcess visitFalse() {
        return this.delegate.visitFalse();
    }

    @Override
    public TraversalProcess visitBoundVar(BooleanFormula var, int deBruijnIdx) {
        return this.delegate.visitBoundVar(var, deBruijnIdx);
    }

    @Override
    public TraversalProcess visitAtom(BooleanFormula pAtom, FunctionDeclaration decl) {
        return this.delegate.visitAtom(pAtom, decl);
    }

    @Override
    public TraversalProcess visitNot(BooleanFormula pOperand) {
        TraversalProcess result = this.delegate.visitNot(pOperand);
        if (result == TraversalProcess.CONTINUE) {
            this.addToQueue(pOperand);
        }
        return result;
    }

    @Override
    public TraversalProcess visitAnd(List<BooleanFormula> pOperands) {
        TraversalProcess result = this.delegate.visitAnd(pOperands);
        this.addToQueueIfNecessary(result, pOperands);
        return result;
    }

    @Override
    public TraversalProcess visitOr(List<BooleanFormula> pOperands) {
        TraversalProcess result = this.delegate.visitOr(pOperands);
        this.addToQueueIfNecessary(result, pOperands);
        return result;
    }

    @Override
    public TraversalProcess visitXor(BooleanFormula operand1, BooleanFormula operand2) {
        TraversalProcess result = this.delegate.visitXor(operand1, operand2);
        this.addToQueueIfNecessary(result, (List<BooleanFormula>)ImmutableList.of((Object)operand1, (Object)operand2));
        return result;
    }

    @Override
    public TraversalProcess visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        TraversalProcess result = this.delegate.visitEquivalence(pOperand1, pOperand2);
        this.addToQueueIfNecessary(result, pOperand1, pOperand2);
        return result;
    }

    @Override
    public TraversalProcess visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        TraversalProcess result = this.delegate.visitImplication(pOperand1, pOperand2);
        this.addToQueueIfNecessary(result, pOperand1, pOperand2);
        return result;
    }

    @Override
    public TraversalProcess visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
        TraversalProcess result = this.delegate.visitIfThenElse(pCondition, pThenFormula, pElseFormula);
        if (result == TraversalProcess.CONTINUE) {
            this.addToQueue(pCondition);
            this.addToQueue(pThenFormula);
            this.addToQueue(pElseFormula);
        }
        return result;
    }

    @Override
    public TraversalProcess visitQuantifier(QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> boundVars, BooleanFormula pBody) {
        TraversalProcess result = this.delegate.visitQuantifier(pQuantifier, boundVars, pBody);
        if (result == TraversalProcess.CONTINUE) {
            this.addToQueue(pBody);
        }
        return result;
    }
}

