/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;

abstract class AbstractFormula<TFormulaInfo>
implements Formula {
    private final TFormulaInfo formulaInfo;

    private AbstractFormula(TFormulaInfo formulaInfo) {
        this.formulaInfo = Preconditions.checkNotNull(formulaInfo);
    }

    public final boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractFormula)) {
            return false;
        }
        return this.formulaInfo.equals(((AbstractFormula)o).formulaInfo);
    }

    final TFormulaInfo getFormulaInfo() {
        return this.formulaInfo;
    }

    public final int hashCode() {
        return this.formulaInfo.hashCode();
    }

    public final String toString() {
        return this.formulaInfo.toString();
    }

    static final class RationalFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements NumeralFormula.RationalFormula {
        RationalFormulaImpl(TFormulaInfo pTerm) {
            super(pTerm);
        }
    }

    static final class IntegerFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements NumeralFormula.IntegerFormula {
        IntegerFormulaImpl(TFormulaInfo pTerm) {
            super(pTerm);
        }
    }

    static final class BooleanFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements BooleanFormula {
        BooleanFormulaImpl(TFormulaInfo pT) {
            super(pT);
        }
    }

    static final class FloatingPointFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements FloatingPointFormula {
        FloatingPointFormulaImpl(TFormulaInfo info) {
            super(info);
        }
    }

    static final class BitvectorFormulaImpl<TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements BitvectorFormula {
        BitvectorFormulaImpl(TFormulaInfo info) {
            super(info);
        }
    }

    static final class ArrayFormulaImpl<TI extends Formula, TE extends Formula, TFormulaInfo>
    extends AbstractFormula<TFormulaInfo>
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        ArrayFormulaImpl(TFormulaInfo info, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(info);
            this.indexType = (FormulaType)Preconditions.checkNotNull(pIndexType);
            this.elementType = (FormulaType)Preconditions.checkNotNull(pElementType);
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

