/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.FormulaCreator;

abstract class AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv> {
    protected final FormulaCreator<TFormulaInfo, TType, TEnv> formulaCreator;
    final Function<Formula, TFormulaInfo> extractor = new Function<Formula, TFormulaInfo>(){

        public TFormulaInfo apply(Formula pInput) {
            return AbstractBaseFormulaManager.this.extractInfo(pInput);
        }
    };

    AbstractBaseFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pFormulaCreator) {
        this.formulaCreator = pFormulaCreator;
    }

    protected final FormulaCreator<TFormulaInfo, TType, TEnv> getFormulaCreator() {
        return this.formulaCreator;
    }

    final TFormulaInfo extractInfo(Formula pBits) {
        return this.getFormulaCreator().extractInfo(pBits);
    }

    final BooleanFormula wrapBool(TFormulaInfo pTerm) {
        return this.getFormulaCreator().encapsulateBoolean(pTerm);
    }

    protected final TType toSolverType(FormulaType<?> formulaType) {
        TType t;
        if (formulaType.isBooleanType()) {
            t = this.getFormulaCreator().getBoolType();
        } else if (formulaType.isIntegerType()) {
            t = this.getFormulaCreator().getIntegerType();
        } else if (formulaType.isRationalType()) {
            t = this.getFormulaCreator().getRationalType();
        } else if (formulaType.isBitvectorType()) {
            FormulaType.BitvectorType bitPreciseType = (FormulaType.BitvectorType)formulaType;
            t = this.getFormulaCreator().getBitvectorType(bitPreciseType.getSize());
        } else if (formulaType.isFloatingPointType()) {
            FormulaType.FloatingPointType fpType = (FormulaType.FloatingPointType)formulaType;
            t = this.getFormulaCreator().getFloatingPointType(fpType);
        } else if (formulaType.isArrayType()) {
            FormulaType.ArrayFormulaType arrType = (FormulaType.ArrayFormulaType)formulaType;
            TType indexType = this.toSolverType(arrType.getIndexType());
            TType elementType = this.toSolverType(arrType.getElementType());
            t = this.getFormulaCreator().getArrayType(indexType, elementType);
        } else {
            throw new IllegalArgumentException("Not supported interface");
        }
        return t;
    }
}

