/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.ArrayFormulaManager;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;

public abstract class AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements ArrayFormulaManager {
    public AbstractArrayFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pFormulaCreator) {
        super(pFormulaCreator);
    }

    @Override
    public <TI extends Formula, TE extends Formula> TE select(ArrayFormula<TI, TE> pArray, Formula pIndex) {
        FormulaType<TE> elementType = this.getFormulaCreator().getArrayFormulaElementType(pArray);
        Object term = this.select(this.extractInfo(pArray), this.extractInfo(pIndex));
        return this.getFormulaCreator().encapsulate(elementType, term);
    }

    protected abstract TFormulaInfo select(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> store(ArrayFormula<TI, TE> pArray, Formula pIndex, Formula pValue) {
        FormulaType<TI> indexType = this.getFormulaCreator().getArrayFormulaIndexType(pArray);
        FormulaType<TE> elementType = this.getFormulaCreator().getArrayFormulaElementType(pArray);
        Object term = this.store(this.extractInfo(pArray), this.extractInfo(pIndex), this.extractInfo(pValue));
        return this.getFormulaCreator().encapsulateArray(term, indexType, elementType);
    }

    protected abstract TFormulaInfo store(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeArray(String pName, FormulaType.ArrayFormulaType<TI, TE> type) {
        return this.makeArray(pName, type.getIndexType(), type.getElementType());
    }

    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, FTI pIndexType, FTE pElementType) {
        TFormulaInfo namedArrayFormula = this.internalMakeArray(pName, pIndexType, pElementType);
        return this.getFormulaCreator().encapsulateArray(namedArrayFormula, pIndexType, pElementType);
    }

    protected abstract <TI extends Formula, TE extends Formula> TFormulaInfo internalMakeArray(String var1, FormulaType<TI> var2, FormulaType<TE> var3);

    @Override
    public <TI extends Formula> FormulaType<TI> getIndexType(ArrayFormula<TI, ?> pArray) {
        return this.getFormulaCreator().getArrayFormulaIndexType(pArray);
    }

    @Override
    public <TE extends Formula> FormulaType<TE> getElementType(ArrayFormula<?, TE> pArray) {
        return this.getFormulaCreator().getArrayFormulaElementType(pArray);
    }

    @Override
    public <TI extends Formula, TE extends Formula> BooleanFormula equivalence(ArrayFormula<TI, TE> pArray1, ArrayFormula<TI, TE> pArray2) {
        return this.getFormulaCreator().encapsulateBoolean(this.equivalence(this.extractInfo(pArray1), this.extractInfo(pArray2)));
    }

    protected abstract TFormulaInfo equivalence(TFormulaInfo var1, TFormulaInfo var2);
}

