/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.solver.api.ArrayFormulaManager;
import org.sosy_lab.solver.api.BitvectorFormulaManager;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.FloatingPointFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionFormulaManager;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.api.RationalFormulaManager;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.tactics.Tactic;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

public interface FormulaManager {
    public IntegerFormulaManager getIntegerFormulaManager();

    public RationalFormulaManager getRationalFormulaManager();

    public BooleanFormulaManager getBooleanFormulaManager();

    public ArrayFormulaManager getArrayFormulaManager();

    public BitvectorFormulaManager getBitvectorFormulaManager();

    public FloatingPointFormulaManager getFloatingPointFormulaManager();

    public FunctionFormulaManager getFunctionFormulaManager();

    public QuantifiedFormulaManager getQuantifiedFormulaManager();

    public <T extends Formula> BooleanFormula makeEqual(T var1, T var2);

    public <T extends Formula> T makeVariable(FormulaType<T> var1, String var2);

    public <T extends Formula> FormulaType<T> getFormulaType(T var1);

    public BooleanFormula parse(String var1) throws IllegalArgumentException;

    public Appender dumpFormula(BooleanFormula var1);

    public BooleanFormula applyTactic(BooleanFormula var1, Tactic var2) throws InterruptedException;

    public <T extends Formula> T simplify(T var1);

    @CanIgnoreReturnValue
    public <R> R visit(FormulaVisitor<R> var1, Formula var2);

    public void visitRecursively(FormulaVisitor<TraversalProcess> var1, Formula var2);

    public <T extends Formula> T transformRecursively(FormulaTransformationVisitor var1, T var2);

    public Map<String, Formula> extractVariables(Formula var1);

    public Map<String, Formula> extractVariablesAndUFs(Formula var1);

    public <T extends Formula> T substitute(T var1, Map<? extends Formula, ? extends Formula> var2);

    public BooleanFormula translate(BooleanFormula var1, SolverContext var2);

    public <T extends Formula> List<T> splitNumeralEqualityIfPossible(T var1);
}

