/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3java;

import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Sort;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.solver.z3java.Z3BooleanFormulaManager;
import org.sosy_lab.solver.z3java.Z3FormulaCreator;
import org.sosy_lab.solver.z3java.Z3NativeApiHelpers;

class Z3QuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<Expr, Sort, Context> {
    private final Context z3context;

    Z3QuantifiedFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Context)creator.getEnv();
    }

    @Override
    protected Expr exists(List<Expr> pVariables, Expr pBody) {
        return this.mkQuantifier(QuantifiedFormulaManager.Quantifier.EXISTS, pVariables, pBody);
    }

    @Override
    protected Expr forall(List<Expr> pVariables, Expr pBody) {
        return this.mkQuantifier(QuantifiedFormulaManager.Quantifier.FORALL, pVariables, pBody);
    }

    @Override
    public Expr mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<Expr> pVariables, Expr pBody) {
        return this.z3context.mkQuantifier(q == QuantifiedFormulaManager.Quantifier.FORALL, pVariables.toArray(new Expr[0]), pBody, 0, null, null, null, null);
    }

    @Override
    protected Expr eliminateQuantifiers(Expr pExtractInfo) throws SolverException, InterruptedException {
        return Z3NativeApiHelpers.applyTactics(this.z3context, Z3BooleanFormulaManager.toBool(pExtractInfo), "qe-light", "qe");
    }
}

