/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.LongArrayBackedList;
import org.sosy_lab.solver.z3.Z3AbstractProver;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3FormulaManager;
import org.sosy_lab.solver.z3.Z3NativeApi;
import org.sosy_lab.solver.z3.Z3NativeApiConstants;
import org.sosy_lab.solver.z3.Z3SolverException;

class Z3TheoremProver
extends Z3AbstractProver<Void>
implements ProverEnvironment {
    private final long z3solver;
    private int level = 0;
    private final UniqueIdGenerator trackId = new UniqueIdGenerator();
    private final FormulaManager mgr;
    private static final String UNSAT_CORE_TEMP_VARNAME = "UNSAT_CORE_%d";
    @Nullable
    private final Map<String, BooleanFormula> storedConstraints;

    Z3TheoremProver(Z3FormulaCreator creator, Z3FormulaManager pMgr, long z3params, ShutdownNotifier pShutdownNotifier, SolverContext.ProverOptions ... options) {
        super(creator, pShutdownNotifier);
        this.mgr = pMgr;
        this.z3solver = Z3NativeApi.mk_solver(this.z3context);
        Z3NativeApi.solver_inc_ref(this.z3context, this.z3solver);
        Z3NativeApi.solver_set_params(this.z3context, this.z3solver, z3params);
        HashSet opts = Sets.newHashSet((Object[])options);
        this.storedConstraints = opts.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) ? new HashMap<String, BooleanFormula>() : null;
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((Z3NativeApi.solver_get_num_scopes(this.z3context, this.z3solver) >= 1 ? 1 : 0) != 0);
        --this.level;
        Z3NativeApi.solver_pop(this.z3context, this.z3solver, 1);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long e = Z3FormulaManager.getZ3Expr(f);
        Z3NativeApi.inc_ref(this.z3context, e);
        if (this.storedConstraints != null) {
            String varName = String.format(UNSAT_CORE_TEMP_VARNAME, this.trackId.getFreshId());
            BooleanFormula t = this.mgr.getBooleanFormulaManager().makeVariable(varName);
            Z3NativeApi.solver_assert_and_track(this.z3context, this.z3solver, e, this.creator.extractInfo(t));
            this.storedConstraints.put(varName, f);
        } else {
            Z3NativeApi.solver_assert(this.z3context, this.z3solver, e);
        }
        Z3NativeApi.dec_ref(this.z3context, e);
        return null;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ++this.level;
        Z3NativeApi.solver_push(this.z3context, this.z3solver);
    }

    @Override
    public boolean isUnsat() throws Z3SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int result = Z3NativeApi.solver_check(this.z3context, this.z3solver);
        this.shutdownNotifier.shutdownIfNecessary();
        Preconditions.checkArgument((result != Z3NativeApiConstants.Z3_LBOOL.Z3_L_UNDEF.status ? 1 : 0) != 0, (Object)"Solver returned UNDEFINED status");
        return result == Z3NativeApiConstants.Z3_LBOOL.Z3_L_FALSE.status;
    }

    @Override
    protected long getZ3Model() {
        return Z3NativeApi.solver_get_model(this.z3context, this.z3solver);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.storedConstraints == null) {
            throw new UnsupportedOperationException("Option to generate the UNSAT core wasn't enabled when creating the prover environment.");
        }
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        long unsatCore = Z3NativeApi.solver_get_unsat_core(this.z3context, this.z3solver);
        Z3NativeApi.ast_vector_inc_ref(this.z3context, unsatCore);
        for (int i = 0; i < Z3NativeApi.ast_vector_size(this.z3context, unsatCore); ++i) {
            long ast = Z3NativeApi.ast_vector_get(this.z3context, unsatCore, i);
            Z3NativeApi.inc_ref(this.z3context, ast);
            String varName = Z3NativeApi.ast_to_string(this.z3context, ast);
            Z3NativeApi.dec_ref(this.z3context, ast);
            constraints.add(this.storedConstraints.get(varName));
        }
        Z3NativeApi.ast_vector_dec_ref(this.z3context, unsatCore);
        return constraints;
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((Z3NativeApi.solver_get_num_scopes(this.z3context, this.z3solver) >= 0 ? 1 : 0) != 0, (Object)"a negative number of scopes is not allowed");
        while (this.level > 0) {
            this.pop();
        }
        Z3NativeApi.solver_dec_ref(this.z3context, this.z3solver);
        this.closed = true;
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] importantFormulas = new long[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            importantFormulas[i++] = Z3FormulaManager.getZ3Expr(impF);
        }
        Z3NativeApi.solver_push(this.z3context, this.z3solver);
        while (Z3NativeApi.solver_check(this.z3context, this.z3solver) == Z3NativeApiConstants.Z3_LBOOL.Z3_L_TRUE.status) {
            long[] valuesOfModel = new long[importantFormulas.length];
            long z3model = Z3NativeApi.solver_get_model(this.z3context, this.z3solver);
            for (int j = 0; j < importantFormulas.length; ++j) {
                long funcDecl = Z3NativeApi.get_app_decl(this.z3context, importantFormulas[j]);
                long valueOfExpr = Z3NativeApi.model_get_const_interp(this.z3context, z3model, funcDecl);
                if (Z3NativeApiConstants.isOP(this.z3context, valueOfExpr, 257)) {
                    valuesOfModel[j] = Z3NativeApi.mk_not(this.z3context, importantFormulas[j]);
                    Z3NativeApi.inc_ref(this.z3context, valuesOfModel[j]);
                    continue;
                }
                valuesOfModel[j] = importantFormulas[j];
            }
            callback.apply((List<BooleanFormula>)new LongArrayBackedList<BooleanFormula>(valuesOfModel){

                @Override
                protected BooleanFormula convert(long pE) {
                    return Z3TheoremProver.this.creator.encapsulateBoolean(pE);
                }
            });
            long negatedModel = Z3NativeApi.mk_not(this.z3context, Z3NativeApi.mk_and(this.z3context, valuesOfModel));
            Z3NativeApi.inc_ref(this.z3context, negatedModel);
            Z3NativeApi.solver_assert(this.z3context, this.z3solver, negatedModel);
        }
        Z3NativeApi.solver_pop(this.z3context, this.z3solver, 1);
        return callback.getResult();
    }
}

