/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;

abstract class Z3NumeralFormulaManager<ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractNumeralFormulaManager<Long, Long, Long, ParamFormulaType, ResultFormulaType> {
    protected final long z3context;

    Z3NumeralFormulaManager(Z3FormulaCreator pCreator) {
        super(pCreator);
        this.z3context = (Long)pCreator.getEnv();
    }

    protected abstract long getNumeralType();

    @Override
    protected boolean isNumeral(Long val) {
        return Z3NativeApi.is_numeral_ast(this.z3context, val);
    }

    @Override
    protected Long makeNumberImpl(long i) {
        long sort = this.getNumeralType();
        return Z3NativeApi.mk_int64(this.z3context, i, sort);
    }

    @Override
    protected Long makeNumberImpl(BigInteger pI) {
        return this.makeNumberImpl(pI.toString());
    }

    @Override
    protected Long makeNumberImpl(String pI) {
        long sort = this.getNumeralType();
        return Z3NativeApi.mk_numeral(this.z3context, pI, sort);
    }

    @Override
    protected Long makeVariableImpl(String varName) {
        long type = this.getNumeralType();
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    public Long negate(Long pNumber) {
        long sort = Z3NativeApi.get_sort(this.z3context, pNumber);
        long minusOne = Z3NativeApi.mk_int(this.z3context, -1, sort);
        return Z3NativeApi.mk_mul(this.z3context, minusOne, pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_add(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long sumImpl(List<Long> operands) {
        return Z3NativeApi.mk_add(this.z3context, operands.size(), Longs.toArray(operands));
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_sub(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_div(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_mul(this.z3context, pNumber1, pNumber2);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return Z3NativeApi.mk_true(this.z3context);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_eq(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_gt(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_ge(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_lt(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_le(this.z3context, pNumber1, pNumber2);
    }
}

