/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.z3;

import java.math.BigInteger;
import org.sosy_lab.solver.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.solver.z3.Z3FormulaCreator;
import org.sosy_lab.solver.z3.Z3NativeApi;

class Z3BitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Long, Long, Long> {
    private final long z3context;

    Z3BitvectorFormulaManager(Z3FormulaCreator creator) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
    }

    @Override
    public Long concat(Long pFirst, Long pSecond) {
        return Z3NativeApi.mk_concat(this.z3context, pFirst, pSecond);
    }

    @Override
    public Long extract(Long pFirst, int pMsb, int pLsb, boolean pSigned) {
        return Z3NativeApi.mk_extract(this.z3context, pMsb, pLsb, pFirst);
    }

    @Override
    public Long extend(Long pNumber, int pExtensionBits, boolean pSigned) {
        if (pSigned) {
            return Z3NativeApi.mk_sign_ext(this.z3context, pExtensionBits, pNumber);
        }
        return Z3NativeApi.mk_zero_ext(this.z3context, pExtensionBits, pNumber);
    }

    @Override
    public Long makeBitvectorImpl(int pLength, long pI) {
        long sort = Z3NativeApi.mk_bv_sort(this.z3context, pLength);
        return Z3NativeApi.mk_int64(this.z3context, pI, sort);
    }

    @Override
    protected Long makeBitvectorImpl(int pLength, BigInteger pI) {
        long sort = Z3NativeApi.mk_bv_sort(this.z3context, pLength);
        return Z3NativeApi.mk_numeral(this.z3context, pI.toString(), sort);
    }

    @Override
    public Long makeVariableImpl(int length, String varName) {
        long type = (Long)this.getFormulaCreator().getBitvectorType(length);
        return (Long)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    public Long shiftRight(Long number, Long toShift, boolean signed) {
        if (signed) {
            return Z3NativeApi.mk_bvashr(this.z3context, number, toShift);
        }
        return Z3NativeApi.mk_bvlshr(this.z3context, number, toShift);
    }

    @Override
    public Long shiftLeft(Long number, Long toShift) {
        return Z3NativeApi.mk_bvshl(this.z3context, number, toShift);
    }

    @Override
    public Long not(Long pBits) {
        return Z3NativeApi.mk_bvnot(this.z3context, pBits);
    }

    @Override
    public Long and(Long pBits1, Long pBits2) {
        return Z3NativeApi.mk_bvand(this.z3context, pBits1, pBits2);
    }

    @Override
    public Long or(Long pBits1, Long pBits2) {
        return Z3NativeApi.mk_bvor(this.z3context, pBits1, pBits2);
    }

    @Override
    public Long xor(Long pBits1, Long pBits2) {
        return Z3NativeApi.mk_bvxor(this.z3context, pBits1, pBits2);
    }

    @Override
    public Long negate(Long pNumber) {
        return Z3NativeApi.mk_bvneg(this.z3context, pNumber);
    }

    @Override
    public Long add(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_bvadd(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long subtract(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_bvsub(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long divide(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Z3NativeApi.mk_bvsdiv(this.z3context, pNumber1, pNumber2);
        }
        return Z3NativeApi.mk_bvudiv(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long modulo(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Z3NativeApi.mk_bvsrem(this.z3context, pNumber1, pNumber2);
        }
        return Z3NativeApi.mk_bvurem(this.z3context, pNumber1, pNumber2);
    }

    @Override
    protected Long modularCongruence(Long pNumber1, Long pNumber2, long pModulo) {
        return Z3NativeApi.mk_true(this.z3context);
    }

    @Override
    public Long multiply(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_bvmul(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long equal(Long pNumber1, Long pNumber2) {
        return Z3NativeApi.mk_eq(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long lessThan(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Z3NativeApi.mk_bvslt(this.z3context, pNumber1, pNumber2);
        }
        return Z3NativeApi.mk_bvult(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long lessOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        if (signed) {
            return Z3NativeApi.mk_bvsle(this.z3context, pNumber1, pNumber2);
        }
        return Z3NativeApi.mk_bvule(this.z3context, pNumber1, pNumber2);
    }

    @Override
    public Long greaterThan(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessThan(pNumber2, pNumber1, signed);
    }

    @Override
    public Long greaterOrEquals(Long pNumber1, Long pNumber2, boolean signed) {
        return this.lessOrEquals(pNumber2, pNumber1, signed);
    }
}

