/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.UfDeclaration;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverBasicTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void formulaEqualsAndHashCode() {
        UfDeclaration<NumeralFormula.IntegerFormula> f_b = this.fmgr.declareUninterpretedFunction("f_b", FormulaType.IntegerType, FormulaType.IntegerType);
        new EqualsTester().addEqualityGroup(new Object[]{this.bmgr.makeBoolean(true)}).addEqualityGroup(new Object[]{this.bmgr.makeBoolean(false)}).addEqualityGroup(new Object[]{this.bmgr.makeVariable("bool_a")}).addEqualityGroup(new Object[]{this.imgr.makeVariable("int_a")}).addEqualityGroup(new Object[]{this.imgr.makeNumber(0.0), this.imgr.makeNumber(0L), this.imgr.makeNumber(BigInteger.ZERO), this.imgr.makeNumber(BigDecimal.ZERO), this.imgr.makeNumber("0")}).addEqualityGroup(new Object[]{this.imgr.makeNumber(1.0), this.imgr.makeNumber(1L), this.imgr.makeNumber(BigInteger.ONE), this.imgr.makeNumber(BigDecimal.ONE), this.imgr.makeNumber("1")}).addEqualityGroup(new Object[]{this.bmgr.makeVariable("bool_b"), this.bmgr.makeVariable("bool_b")}).addEqualityGroup(new Object[]{this.bmgr.and(this.bmgr.makeVariable("bool_a"), this.bmgr.makeVariable("bool_b")), this.bmgr.and(this.bmgr.makeVariable("bool_a"), this.bmgr.makeVariable("bool_b"))}).addEqualityGroup(new Object[]{this.imgr.equal(this.imgr.makeNumber(0L), this.imgr.makeVariable("int_a")), this.imgr.equal(this.imgr.makeNumber(0L), this.imgr.makeVariable("int_a"))}).addEqualityGroup(new Object[]{this.fmgr.declareUninterpretedFunction("f_a", FormulaType.IntegerType, FormulaType.IntegerType), this.fmgr.declareUninterpretedFunction("f_a", FormulaType.IntegerType, FormulaType.IntegerType)}).addEqualityGroup(new Object[]{f_b}).addEqualityGroup(new Object[]{this.fmgr.callUninterpretedFunction(f_b, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(0L)))}).addEqualityGroup(new Object[]{this.fmgr.callUninterpretedFunction(f_b, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(1L))), this.fmgr.callUninterpretedFunction(f_b, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(1L)))}).testEquals();
    }

    @Test
    public void variableNameExtractorTest() throws Exception {
        BooleanFormula constr = this.bmgr.or(this.imgr.equal(this.imgr.subtract(this.imgr.add(this.imgr.makeVariable("x"), this.imgr.makeVariable("z")), this.imgr.makeNumber(10L)), this.imgr.makeVariable("y")), this.imgr.equal(this.imgr.makeVariable("xx"), this.imgr.makeVariable("zz")));
        Truth.assertThat(this.mgr.extractVariables(constr).keySet()).containsExactly(new Object[]{"x", "y", "z", "xx", "zz"});
        Truth.assertThat(this.mgr.extractVariablesAndUFs(constr)).isEqualTo(this.mgr.extractVariables(constr));
    }

    @Test
    public void ufNameExtractorTest() throws Exception {
        BooleanFormula constraint = this.imgr.equal((NumeralFormula)this.fmgr.declareAndCallUninterpretedFunction("uf1", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("x"))), (NumeralFormula)this.fmgr.declareAndCallUninterpretedFunction("uf2", FormulaType.IntegerType, (List<Formula>)ImmutableList.of(this.imgr.makeVariable("y"))));
        Truth.assertThat(this.mgr.extractVariablesAndUFs(constraint).keySet()).containsExactly(new Object[]{"uf1", "uf2", "x", "y"});
        Truth.assertThat(this.mgr.extractVariables(constraint).keySet()).containsExactly(new Object[]{"x", "y"});
    }
}

