/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.test.SolverBasedTest0;
import org.sosy_lab.solver.visitors.DefaultFormulaVisitor;

@RunWith(value=Parameterized.class)
public class QuantifierManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    private NumeralFormula.IntegerFormula x;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> a;
    private BooleanFormula a_at_x_eq_1;
    private BooleanFormula a_at_x_eq_0;
    private BooleanFormula forall_x_a_at_x_eq_0;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    @Before
    public void setUp() throws Exception {
        this.requireArrays();
        this.requireQuantifiers();
        TruthJUnit.assume().withFailureMessage("Quantifier support in Princess is currently not complete.").that((Comparable)((Object)this.solverUnderTest)).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        this.a = this.amgr.makeArray("b", FormulaType.IntegerType, FormulaType.IntegerType);
        this.a_at_x_eq_1 = this.imgr.equal((NumeralFormula)this.amgr.select(this.a, this.x), this.imgr.makeNumber(1L));
        this.a_at_x_eq_0 = this.imgr.equal((NumeralFormula)this.amgr.select(this.a, this.x), this.imgr.makeNumber(0L));
        this.forall_x_a_at_x_eq_0 = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0);
    }

    @Test
    public void testForallArrayConjunctUnsat() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testForallArrayConjunctSat() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(0L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testForallArrayDisjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.bmgr.or(this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testForallArrayDisjunctSat2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.or(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testNotExistsArrayConjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L))}));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testNotExistsArrayConjunct2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(0L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testNotExistsArrayConjunct3() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0)), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(0L)));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testNotExistsArrayDisjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.bmgr.or(this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(0L))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testNotExistsArrayDisjunct2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.or(Lists.newArrayList((Object[])new BooleanFormula[]{this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L))}));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayConjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal((NumeralFormula)this.amgr.select(this.a, (Formula)this.imgr.makeNumber(123L)), this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayConjunct2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1), this.forall_x_a_at_x_eq_0);
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testExistsArrayConjunct3() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.forall_x_a_at_x_eq_0);
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayDisjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.or(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayDisjunct2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.or(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1), this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testContradiction() throws SolverException, InterruptedException {
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.imgr.equal(this.x, this.imgr.add(this.x, this.imgr.makeNumber(1L))));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testSimple() throws SolverException, InterruptedException {
        assert (this.qmgr != null);
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.imgr.equal(this.imgr.add(this.x, this.imgr.makeNumber(2L)), this.imgr.add(this.imgr.add(this.x, this.imgr.makeNumber(1L)), this.imgr.makeNumber(1L))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testBlah() throws Exception {
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        assert (this.qmgr != null);
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)z), this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)y), this.imgr.equal(z, y)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testEquals() {
        assert (this.qmgr != null);
        BooleanFormula f1 = this.qmgr.exists((List<? extends Formula>)ImmutableList.of(this.imgr.makeVariable("x")), this.a_at_x_eq_1);
        BooleanFormula f2 = this.qmgr.exists((List<? extends Formula>)ImmutableList.of(this.imgr.makeVariable("x")), this.a_at_x_eq_1);
        Truth.assertThat((Object)f1).isEqualTo((Object)f2);
    }

    @Test
    public void testIntrospectionForall() {
        assert (this.qmgr != null);
        BooleanFormula forall = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0);
        final AtomicBoolean isQuantifier = new AtomicBoolean(false);
        final AtomicBoolean isForall = new AtomicBoolean(false);
        final AtomicInteger numBound = new AtomicInteger(0);
        this.mgr.visit(new DefaultFormulaVisitor<Void>(){

            @Override
            protected Void visitDefault(Formula f) {
                return null;
            }

            @Override
            public Void visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
                isForall.set(quantifier == QuantifiedFormulaManager.Quantifier.FORALL);
                isQuantifier.set(true);
                numBound.set(boundVariables.size());
                return null;
            }
        }, forall);
    }

    @Test
    public void testIntrospectionExists() {
        assert (this.qmgr != null);
        TruthJUnit.assume().withFailureMessage("Bug in Z3QuantifiedFormulaManager").that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.Z3, (Object)SolverContextFactory.Solvers.Z3JAVA, new Object[0]);
        BooleanFormula exists = this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0);
        final AtomicBoolean isQuantifier = new AtomicBoolean(false);
        final AtomicBoolean isForall = new AtomicBoolean(false);
        final AtomicInteger numBound = new AtomicInteger(0);
        this.mgr.visit(new DefaultFormulaVisitor<Void>(){

            @Override
            protected Void visitDefault(Formula f) {
                return null;
            }

            @Override
            public Void visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
                isForall.set(quantifier == QuantifiedFormulaManager.Quantifier.FORALL);
                isQuantifier.set(true);
                numBound.set(boundVariables.size());
                return null;
            }
        }, exists);
        Truth.assertThat((Boolean)isQuantifier.get()).isTrue();
        Truth.assertThat((Boolean)isForall.get()).isFalse();
        Truth.assertThat((Integer)numBound.get()).isEqualTo((Object)1);
    }
}

