/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.test;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.solver.SolverContextFactory;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testSubstitution() throws SolverException, InterruptedException {
        System.out.println("Solver Version = " + this.context.getVersion());
        BooleanFormula input = this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("a"), this.bmgr.makeVariable("b")), this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")));
        BooleanFormula out = this.mgr.substitute(input, (Map<? extends Formula, ? extends Formula>)ImmutableMap.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("a1"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("b1"), (Object)this.bmgr.and(this.bmgr.makeVariable("c"), this.bmgr.makeVariable("d")), (Object)this.bmgr.makeVariable("e")));
        this.assertThatFormula(out).isEquivalentTo(this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("a1"), this.bmgr.makeVariable("b1")), this.bmgr.makeVariable("e")));
    }
}

