/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.smtinterpol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.smtinterpol.SmtInterpolEnvironment;
import org.sosy_lab.solver.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.solver.smtinterpol.SmtInterpolModel;

class SmtInterpolTheoremProver
implements ProverEnvironment {
    private final SmtInterpolFormulaManager mgr;
    private final SmtInterpolEnvironment env;
    private final List<Term> assertedTerms;
    private final FormulaCreator<Term, Sort, SmtInterpolEnvironment> creator;
    private boolean closed = false;

    SmtInterpolTheoremProver(SmtInterpolFormulaManager pMgr, FormulaCreator<Term, Sort, SmtInterpolEnvironment> pCreator) {
        this.mgr = pMgr;
        this.assertedTerms = new ArrayList<Term>();
        this.env = this.mgr.createEnvironment();
        this.creator = pCreator;
        Preconditions.checkNotNull((Object)this.env);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return !this.env.checkSat();
    }

    @Override
    public Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        return new SmtInterpolModel(this.env.getModel(), this.creator, this.assertedTerms);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedTerms.remove(this.assertedTerms.size() - 1);
        this.env.pop(1);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term t = (Term)this.mgr.extractInfo(constraint);
        this.assertedTerms.add(t);
        this.env.assertTerm(t);
        return null;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.env.push(1);
    }

    @Override
    public Void push(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term t = (Term)this.mgr.extractInfo(f);
        this.assertedTerms.add(t);
        this.push();
        this.env.assertTerm(t);
        return null;
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (!this.assertedTerms.isEmpty()) {
            this.env.pop(this.assertedTerms.size());
            this.assertedTerms.clear();
        }
        this.closed = true;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term[] terms = this.env.getUnsatCore();
        return Lists.transform(Arrays.asList(terms), this.creator.encapsulateBoolean);
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Term[] importantTerms = new Term[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            importantTerms[i++] = (Term)this.mgr.extractInfo(impF);
        }
        for (Term[] model : this.env.checkAllSat(importantTerms)) {
            callback.apply(Lists.transform(Arrays.asList(model), this.creator.encapsulateBoolean));
        }
        return callback.getResult();
    }
}

