/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.INot;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.princess.PrincessAbstractProver;
import org.sosy_lab.solver.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.princess.PrincessFormulaManager;
import org.sosy_lab.solver.princess.PrincessModel;
import scala.Option;

class PrincessTheoremProver
extends PrincessAbstractProver<Void>
implements ProverEnvironment {
    private final List<IExpression> assertedTerms = new ArrayList<IExpression>();
    private final ShutdownNotifier shutdownNotifier;

    PrincessTheoremProver(PrincessFormulaManager pMgr, ShutdownNotifier pShutdownNotifier, PrincessFormulaCreator creator) {
        super(pMgr, false, creator);
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.isUnsat() ? 1 : 0) != 0, (Object)"model is only available for SAT environments");
        return new PrincessModel(this.stack.getPartialModel(), this.creator, this.assertedTerms);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.assertedTerms.remove(this.assertedTerms.size() - 1);
        this.stack.pop(1);
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        IFormula t = (IFormula)this.mgr.extractInfo(constraint);
        this.assertedTerms.add((IExpression)t);
        this.stack.assertTerm(t);
        return null;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.stack.push(1);
    }

    @Override
    public Void push(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.push();
        this.addConstraint(f);
        return null;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ArrayList<IFormula> importantFormulas = new ArrayList<IFormula>(important.size());
        for (BooleanFormula impF : important) {
            importantFormulas.add((IFormula)this.mgr.extractInfo(impF));
        }
        this.stack.push(1);
        while (this.stack.checkSat()) {
            this.shutdownNotifier.shutdownIfNecessary();
            IBoolLit newFormula = new IBoolLit(true);
            ArrayList<BooleanFormula> wrappedPartialModel = new ArrayList<BooleanFormula>(important.size());
            for (IFormula f : importantFormulas) {
                Option<Object> value = this.stack.evalPartial(f);
                if (!value.isDefined()) continue;
                boolean isTrueValue = (Boolean)value.get();
                IFormula newElement = isTrueValue ? f : new INot(f);
                wrappedPartialModel.add(this.mgr.encapsulateBooleanFormula((IExpression)newElement));
                newFormula = new IBinFormula(IBinJunctor.And(), (IFormula)newFormula, newElement);
            }
            callback.apply(wrappedPartialModel);
            this.stack.assertTerm((IFormula)new INot((IFormula)newFormula));
        }
        this.shutdownNotifier.shutdownIfNecessary();
        this.stack.pop(1);
        return callback.getResult();
    }
}

