/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IQuantified;
import ap.terfor.ConstantTerm;
import ap.terfor.conjunctions.Quantifier;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessTermType;
import scala.collection.Iterable;
import scala.collection.JavaConversions;

public class PrincessQuantifiedFormulaManager
extends AbstractQuantifiedFormulaManager<IExpression, PrincessTermType, PrincessEnvironment> {
    private final PrincessEnvironment env = (PrincessEnvironment)this.getFormulaCreator().getEnv();

    protected PrincessQuantifiedFormulaManager(FormulaCreator<IExpression, PrincessTermType, PrincessEnvironment> pCreator) {
        super(pCreator);
    }

    @Override
    protected IExpression exists(List<IExpression> pVariables, IExpression pBody) {
        return this.mkQuantifier(QuantifiedFormulaManager.Quantifier.EXISTS, pVariables, pBody);
    }

    @Override
    protected IExpression forall(List<IExpression> pVariables, IExpression pBody) {
        return this.mkQuantifier(QuantifiedFormulaManager.Quantifier.FORALL, pVariables, pBody);
    }

    @Override
    public IExpression mkQuantifier(QuantifiedFormulaManager.Quantifier q, List<IExpression> vars, IExpression body) {
        Quantifier.ALL$ pq;
        Preconditions.checkArgument((boolean)(body instanceof IFormula));
        Object object = pq = q == QuantifiedFormulaManager.Quantifier.FORALL ? Quantifier.ALL$.MODULE$ : Quantifier.EX$.MODULE$;
        if (vars.size() == 0) {
            return new IQuantified((Quantifier)pq, (IFormula)body);
        }
        return IExpression.quanConsts((Quantifier)pq, (Iterable)JavaConversions.iterableAsScalaIterable(this.toConstantTerm(vars)), (IFormula)((IFormula)body));
    }

    private List<ConstantTerm> toConstantTerm(List<IExpression> lst) {
        ArrayList<ConstantTerm> retVal = new ArrayList<ConstantTerm>(lst.size());
        for (IExpression f : lst) {
            retVal.add(((IConstant)f).c());
        }
        return retVal;
    }

    @Override
    protected IExpression eliminateQuantifiers(IExpression formula) throws SolverException, InterruptedException {
        Preconditions.checkArgument((boolean)(formula instanceof IFormula));
        return this.env.elimQuantifiers((IFormula)formula);
    }
}

