/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.SimpleAPI;
import ap.parser.IExpression;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.AbstractModel;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.TermExtractionModelIterator;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessTermType;
import scala.Option;

class PrincessModel
extends AbstractModel<IExpression, PrincessTermType, PrincessEnvironment> {
    private final SimpleAPI.PartialModel model;
    private final ImmutableList<IExpression> assertedTerms;

    PrincessModel(SimpleAPI.PartialModel partialModel, FormulaCreator<IExpression, PrincessTermType, PrincessEnvironment> creator, Collection<IExpression> assertedTerms) {
        super(creator);
        this.model = partialModel;
        this.assertedTerms = ImmutableList.copyOf(assertedTerms);
    }

    @Override
    @Nullable
    public Object evaluateImpl(IExpression f) {
        Option out = this.model.evalExpression(f);
        if (out.isEmpty()) {
            return null;
        }
        SimpleAPI.ModelValue value = (SimpleAPI.ModelValue)out.get();
        return this.getValue(value);
    }

    @Override
    public Iterator<Model.ValueAssignment> iterator() {
        return new TermExtractionModelIterator<IExpression>(this.creator, new Function<IExpression, Object>(){

            public Object apply(IExpression input) {
                return PrincessModel.this.evaluateImpl(input);
            }
        }, (Iterable<IExpression>)this.assertedTerms);
    }

    @Override
    public String toString() {
        return this.model.toString();
    }

    private Object getValue(SimpleAPI.ModelValue value) {
        if (value instanceof SimpleAPI.BoolValue) {
            return ((SimpleAPI.BoolValue)value).v();
        }
        if (value instanceof SimpleAPI.IntValue) {
            return ((SimpleAPI.IntValue)value).v().bigIntValue();
        }
        throw new IllegalArgumentException("unhandled model value " + value + " of type " + value.getClass());
    }
}

