/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.parser.IExpression;
import ap.parser.IFormula;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.princess.PrincessAbstractProver;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessFormulaManager;
import org.sosy_lab.solver.princess.PrincessModel;
import org.sosy_lab.solver.princess.PrincessTermType;

class PrincessInterpolatingProver
extends PrincessAbstractProver<Integer>
implements InterpolatingProverEnvironment<Integer> {
    private final List<Integer> assertedFormulas = new ArrayList<Integer>();
    private final Map<Integer, IFormula> annotatedTerms = new HashMap<Integer, IFormula>();
    private static final UniqueIdGenerator counter = new UniqueIdGenerator();

    PrincessInterpolatingProver(PrincessFormulaManager pMgr, FormulaCreator<IExpression, PrincessTermType, PrincessEnvironment> creator) {
        super(pMgr, true, creator);
    }

    @Override
    public Integer push(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.push();
        return this.addConstraint(f);
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Integer removed = this.assertedFormulas.remove(this.assertedFormulas.size() - 1);
        this.annotatedTerms.remove(removed);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        this.stack.pop(1);
    }

    @Override
    public Integer addConstraint(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        int termIndex = counter.getFreshId();
        IFormula t = (IFormula)((IExpression)this.mgr.extractInfo(f));
        this.stack.assertTermInPartition(t, termIndex);
        this.assertedFormulas.add(termIndex);
        this.annotatedTerms.put(termIndex, t);
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        return termIndex;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.stack.push(1);
    }

    @Override
    public BooleanFormula getInterpolant(List<Integer> pTermNamesOfA) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        HashSet<Integer> indexesOfA = new HashSet<Integer>(pTermNamesOfA);
        ImmutableSet indexesOfB = FluentIterable.from(this.assertedFormulas).filter(Predicates.not((Predicate)Predicates.in(indexesOfA))).toSet();
        List<IFormula> itp = this.stack.getInterpolants((List<Set<Integer>>)ImmutableList.of(indexesOfA, (Object)indexesOfB));
        assert (itp.size() == 1);
        return this.mgr.encapsulateBooleanFormula((IExpression)itp.get(0));
    }

    @Override
    public List<BooleanFormula> getSeqInterpolants(List<Set<Integer>> pTermNamesOfA) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        List<IFormula> itps = this.stack.getInterpolants(pTermNamesOfA);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>();
        for (IFormula itp : itps) {
            result.add(this.mgr.encapsulateBooleanFormula((IExpression)itp));
        }
        return result;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<Set<Integer>> partitionedFormulas, int[] startOfSubTree) {
        throw new UnsupportedOperationException("Direct generation of tree interpolants is not supported.\nUse another solver or another strategy for interpolants.");
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.isUnsat() ? 1 : 0) != 0, (Object)"model is only available for SAT environments");
        assert (this.assertedFormulas.size() == this.annotatedTerms.size());
        ArrayList values = Lists.newArrayList(this.annotatedTerms.values());
        return new PrincessModel(this.stack.getPartialModel(), this.creator, values);
    }
}

