/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.parser.IExpression;
import ap.parser.IFunction;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.List;
import org.sosy_lab.solver.basicimpl.AbstractFunctionFormulaManager;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.princess.PrincessTermType;

class PrincessFunctionFormulaManager
extends AbstractFunctionFormulaManager<IExpression, IFunction, PrincessTermType, PrincessEnvironment> {
    private final PrincessFormulaCreator creator;

    PrincessFunctionFormulaManager(PrincessFormulaCreator creator) {
        super(creator);
        this.creator = creator;
    }

    @Override
    protected IExpression createUninterpretedFunctionCallImpl(IFunction pFuncDecl, List<IExpression> pArgs) {
        return this.creator.makeFunction(pFuncDecl, pArgs);
    }

    @Override
    protected IFunction declareUninterpretedFunctionImpl(String pName, PrincessTermType pReturnType, List<PrincessTermType> args) {
        Preconditions.checkArgument((pReturnType == PrincessTermType.Integer || pReturnType == PrincessTermType.Boolean ? 1 : 0) != 0, (Object)"Princess does not support return types of UFs other than Integer");
        Preconditions.checkArgument((boolean)FluentIterable.from(args).allMatch(Predicates.equalTo((Object)((Object)PrincessTermType.Integer))), (Object)"Princess does not support argument types of UFs other than Integer");
        return ((PrincessEnvironment)this.getFormulaCreator().getEnv()).declareFun(pName, args.size(), pReturnType);
    }
}

