/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.basetypes.IdealInt;
import ap.parser.BooleanCompactifier;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IIntFormula;
import ap.parser.IIntLit;
import ap.parser.IIntRelation;
import ap.parser.ITerm;
import ap.parser.PartialEvaluator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sosy_lab.common.Appender;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.basicimpl.AbstractFormulaManager;
import org.sosy_lab.solver.princess.PrincessArrayFormulaManager;
import org.sosy_lab.solver.princess.PrincessBooleanFormulaManager;
import org.sosy_lab.solver.princess.PrincessEnvironment;
import org.sosy_lab.solver.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.princess.PrincessFunctionFormulaManager;
import org.sosy_lab.solver.princess.PrincessIntegerFormulaManager;
import org.sosy_lab.solver.princess.PrincessQuantifiedFormulaManager;
import org.sosy_lab.solver.princess.PrincessTermType;

final class PrincessFormulaManager
extends AbstractFormulaManager<IExpression, PrincessTermType, PrincessEnvironment> {
    private final PrincessFormulaCreator creator;

    PrincessFormulaManager(PrincessFormulaCreator pCreator, PrincessFunctionFormulaManager pFunctionManager, PrincessBooleanFormulaManager pBooleanManager, PrincessIntegerFormulaManager pIntegerManager, PrincessArrayFormulaManager pArrayManager, PrincessQuantifiedFormulaManager pQuantifierManager) {
        super(pCreator, pFunctionManager, pBooleanManager, pIntegerManager, null, null, null, pQuantifierManager, pArrayManager);
        this.creator = pCreator;
    }

    BooleanFormula encapsulateBooleanFormula(IExpression t) {
        return this.getFormulaCreator().encapsulateBoolean(t);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.encapsulateBooleanFormula((IExpression)Iterables.getOnlyElement(((PrincessEnvironment)this.getEnvironment()).parseStringToTerms(pS, this.creator)));
    }

    @Override
    public Appender dumpFormula(IExpression formula) {
        assert (this.getFormulaCreator().getFormulaType(formula) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return ((PrincessEnvironment)this.getEnvironment()).dumpFormula((IFormula)formula, this.creator);
    }

    @Override
    protected IExpression simplify(IExpression f) {
        if (f instanceof IFormula) {
            f = BooleanCompactifier.apply((IFormula)((IFormula)f));
        }
        return PartialEvaluator.apply((IExpression)f);
    }

    @Override
    protected List<? extends IExpression> splitNumeralEqualityIfPossible(IExpression pF) {
        if (pF instanceof IIntFormula && ((IIntFormula)pF).rel() == IIntRelation.EqZero()) {
            return ImmutableList.of((Object)((IIntFormula)pF).t().$less$eq((ITerm)new IIntLit(IdealInt.ZERO())), (Object)((IIntFormula)pF).t().$greater$eq((ITerm)new IIntLit(IdealInt.ZERO())));
        }
        return ImmutableList.of((Object)pF);
    }
}

