/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.princess;

import ap.SimpleAPI;
import ap.parser.IAtom;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.ITerm;
import ap.parser.SMTLineariser;
import ap.parser.SMTParser2InputAbsy;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.solver.princess.PrincessFormulaCreator;
import org.sosy_lab.solver.princess.PrincessSolverContext;
import org.sosy_lab.solver.princess.PrincessStack;
import org.sosy_lab.solver.princess.PrincessTermType;
import org.sosy_lab.solver.princess.SymbolTrackingPrincessStack;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

class PrincessEnvironment {
    private final java.util.Map<String, IFormula> boolVariablesCache = new HashMap<String, IFormula>();
    private final java.util.Map<String, ITerm> intVariablesCache = new HashMap<String, ITerm>();
    private final java.util.Map<String, ITerm> arrayVariablesCache = new HashMap<String, ITerm>();
    private final java.util.Map<String, IFunction> functionsCache = new HashMap<String, IFunction>();
    private final java.util.Map<IFunction, PrincessTermType> functionsReturnTypes = new HashMap<IFunction, PrincessTermType>();
    @Nullable
    private final PathCounterTemplate basicLogfile;
    private final ShutdownNotifier shutdownNotifier;
    private final SimpleAPI api;
    private final List<SymbolTrackingPrincessStack> registeredStacks = new ArrayList<SymbolTrackingPrincessStack>();
    private final List<SymbolTrackingPrincessStack> reusableStacks = new ArrayList<SymbolTrackingPrincessStack>();
    private final List<SymbolTrackingPrincessStack> allStacks = new ArrayList<SymbolTrackingPrincessStack>();
    private final PrincessSolverContext.PrincessOptions princessOptions;

    PrincessEnvironment(@Nullable PathCounterTemplate pBasicLogfile, ShutdownNotifier pShutdownNotifier, PrincessSolverContext.PrincessOptions pOptions) {
        this.basicLogfile = pBasicLogfile;
        this.shutdownNotifier = pShutdownNotifier;
        this.api = this.getNewApi(false);
        this.princessOptions = pOptions;
    }

    PrincessStack getNewStack(boolean useForInterpolation) {
        SymbolTrackingPrincessStack stack;
        Iterator<SymbolTrackingPrincessStack> it = this.reusableStacks.iterator();
        while (it.hasNext()) {
            stack = it.next();
            if (stack.canBeUsedForInterpolation() != useForInterpolation) continue;
            this.registeredStacks.add(stack);
            it.remove();
            return stack;
        }
        SimpleAPI newApi = this.getNewApi(useForInterpolation);
        stack = new SymbolTrackingPrincessStack(this, newApi, useForInterpolation, this.shutdownNotifier, this.princessOptions);
        for (IFormula iFormula : this.boolVariablesCache.values()) {
            stack.addSymbol(iFormula);
        }
        for (ITerm iTerm : this.intVariablesCache.values()) {
            stack.addSymbol(iTerm);
        }
        for (ITerm iTerm : this.arrayVariablesCache.values()) {
            stack.addSymbol(iTerm);
        }
        for (IFunction iFunction : this.functionsCache.values()) {
            stack.addSymbol(iFunction);
        }
        this.registeredStacks.add(stack);
        this.allStacks.add(stack);
        return stack;
    }

    private SimpleAPI getNewApi(boolean useForInterpolation) {
        SimpleAPI newApi;
        if (this.basicLogfile != null) {
            Path logPath = this.basicLogfile.getFreshPath();
            String fileName = logPath.getName();
            String absPath = logPath.getAbsolutePath();
            File directory = new File(absPath.substring(0, absPath.length() - fileName.length()));
            newApi = SimpleAPI.spawnWithLogNoSanitise((String)fileName, (File)directory);
        } else {
            newApi = SimpleAPI.spawnNoSanitise();
        }
        if (useForInterpolation) {
            newApi.setConstructProofs(true);
        }
        return newApi;
    }

    void unregisterStack(SymbolTrackingPrincessStack stack) {
        assert (this.registeredStacks.contains(stack)) : "cannot unregister stack, it is not registered";
        this.registeredStacks.remove(stack);
        this.reusableStacks.add(stack);
    }

    void removeStack(SymbolTrackingPrincessStack stack) {
        assert (this.registeredStacks.contains(stack)) : "cannot remove stack, it is not registered";
        this.registeredStacks.remove(stack);
        this.allStacks.remove(stack);
    }

    public List<IExpression> parseStringToTerms(String s, PrincessFormulaCreator creator) {
        Tuple3 triple = this.api.extractSMTLIBAssertionsSymbols((Reader)new StringReader(s));
        List<IExpression> formula = this.castToExpression(JavaConversions.seqAsJavaList((Seq)((Seq)triple._1())));
        java.util.Map functionTypes = JavaConversions.mapAsJavaMap((Map)((Map)triple._2()));
        java.util.Map constantTypes = JavaConversions.mapAsJavaMap((Map)((Map)triple._3()));
        HashSet<IExpression> declaredFunctions = new HashSet<IExpression>();
        for (IExpression f : formula) {
            declaredFunctions.addAll(creator.extractVariablesAndUFs(f, true).values());
        }
        for (IExpression var : declaredFunctions) {
            if (var instanceof IConstant) {
                SMTParser2InputAbsy.SMTType type = (SMTParser2InputAbsy.SMTType)constantTypes.get(((IConstant)var).c());
                if (type instanceof SMTParser2InputAbsy.SMTArray) {
                    this.arrayVariablesCache.put(var.toString(), (ITerm)var);
                } else {
                    this.intVariablesCache.put(var.toString(), (ITerm)var);
                }
                for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
                    stack.addSymbol((ITerm)((IConstant)var));
                }
                continue;
            }
            if (var instanceof IAtom) {
                this.boolVariablesCache.put(((IAtom)var).pred().name(), (IFormula)var);
                for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
                    stack.addSymbol((IFormula)((IAtom)var));
                }
                continue;
            }
            if (!(var instanceof IFunApp)) continue;
            IFunction fun = ((IFunApp)var).fun();
            this.functionsCache.put(fun.name(), fun);
            this.functionsReturnTypes.put(fun, this.convertToTermType((SMTParser2InputAbsy.SMTFunctionType)functionTypes.get(fun)));
            for (SymbolTrackingPrincessStack stack : this.registeredStacks) {
                stack.addSymbol(fun);
            }
        }
        return formula;
    }

    private PrincessTermType convertToTermType(SMTParser2InputAbsy.SMTFunctionType type) {
        SMTParser2InputAbsy.SMTType resultType = type.result();
        if (resultType.equals(SMTParser2InputAbsy.SMTBool$.MODULE$)) {
            return PrincessTermType.Boolean;
        }
        return PrincessTermType.Integer;
    }

    private List<IExpression> castToExpression(List<IFormula> formula) {
        ArrayList<IExpression> retVal = new ArrayList<IExpression>(formula.size());
        for (IFormula f : formula) {
            retVal.add((IExpression)f);
        }
        return retVal;
    }

    public Appender dumpFormula(IFormula formula, final PrincessFormulaCreator creator) {
        Tuple2 tuple = this.api.abbrevSharedExpressionsWithMap((IExpression)formula, 1);
        final IExpression lettedFormula = (IExpression)tuple._1();
        final java.util.Map abbrevMap = JavaConversions.mapAsJavaMap((Map)((Map)tuple._2()));
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                out.append("(set-logic AUFLIA)\n");
                HashSet<IExpression> allVars = new HashSet<IExpression>(creator.extractVariablesAndUFs(lettedFormula, true).values());
                ArrayDeque<IExpression> declaredFunctions = new ArrayDeque<IExpression>(allVars);
                HashSet<String> doneFunctions = new HashSet<String>();
                HashSet<String> todoAbbrevs = new HashSet<String>();
                while (!declaredFunctions.isEmpty()) {
                    IExpression var = (IExpression)declaredFunctions.poll();
                    String name = PrincessEnvironment.this.getName(var);
                    if (doneFunctions.contains(name)) continue;
                    doneFunctions.add(name);
                    if (name.startsWith("abbrev_")) {
                        todoAbbrevs.add(name);
                        HashSet varsFromAbbrev = new HashSet(creator.extractVariablesAndUFs(abbrevMap.get(var), true).values());
                        for (IExpression addVar : Sets.difference(varsFromAbbrev, allVars)) {
                            declaredFunctions.push(addVar);
                        }
                        allVars.addAll(varsFromAbbrev);
                        continue;
                    }
                    out.append("(declare-fun ").append(name);
                    out.append(" (");
                    if (var instanceof IFunApp) {
                        IFunApp function = (IFunApp)var;
                        Iterator args = JavaConversions.asJavaIterable((Iterable)function.args()).iterator();
                        while (args.hasNext()) {
                            args.next();
                            if (args.hasNext()) {
                                out.append("Int ");
                                continue;
                            }
                            out.append("Int");
                        }
                    }
                    out.append(") ");
                    out.append(PrincessEnvironment.this.getType(var));
                    out.append(")\n");
                }
                for (Map.Entry entry : abbrevMap.entrySet()) {
                    IExpression abbrev = (IExpression)entry.getKey();
                    IExpression fullFormula = (IExpression)entry.getValue();
                    String name = PrincessEnvironment.this.getName((IExpression)Iterables.getOnlyElement(creator.extractVariablesAndUFs(abbrev, true).values()));
                    if (!todoAbbrevs.contains(name)) continue;
                    out.append("(define-fun ").append(name);
                    if (fullFormula instanceof IFormula) {
                        out.append(" () Bool ");
                    } else if (fullFormula instanceof ITerm) {
                        out.append(" () Int ");
                    }
                    out.append(SMTLineariser.asString((IExpression)fullFormula)).append(" )\n");
                }
                out.append("(assert ").append(SMTLineariser.asString((IExpression)lettedFormula)).append(")");
            }
        };
    }

    private String getName(IExpression var) {
        if (var instanceof IAtom) {
            return ((IAtom)var).pred().name();
        }
        if (var instanceof IConstant) {
            return var.toString();
        }
        if (var instanceof IFunApp) {
            String fullStr = ((IFunApp)var).fun().toString();
            return fullStr.substring(0, fullStr.indexOf("/"));
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    private String getType(IExpression var) {
        if (var instanceof IFormula) {
            return "Bool";
        }
        if (var instanceof ITerm) {
            return "Int";
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    public IExpression makeVariable(PrincessTermType type, String varname) {
        switch (type) {
            case Boolean: {
                if (this.boolVariablesCache.containsKey(varname)) {
                    return (IExpression)this.boolVariablesCache.get(varname);
                }
                IFormula var = this.api.createBooleanVariable(varname);
                for (SymbolTrackingPrincessStack stack : this.allStacks) {
                    stack.addSymbol(var);
                }
                this.boolVariablesCache.put(varname, var);
                return var;
            }
            case Integer: {
                if (this.intVariablesCache.containsKey(varname)) {
                    return (IExpression)this.intVariablesCache.get(varname);
                }
                ITerm var = this.api.createConstant(varname);
                for (SymbolTrackingPrincessStack stack : this.allStacks) {
                    stack.addSymbol(var);
                }
                this.intVariablesCache.put(varname, var);
                return var;
            }
            case Array: {
                if (this.arrayVariablesCache.containsKey(varname)) {
                    return (IExpression)this.arrayVariablesCache.get(varname);
                }
                ITerm var = this.api.createConstant(varname);
                for (SymbolTrackingPrincessStack stack : this.allStacks) {
                    stack.addSymbol(var);
                }
                this.arrayVariablesCache.put(varname, var);
                return var;
            }
        }
        throw new AssertionError((Object)("unsupported type: " + (Object)((Object)type)));
    }

    public IFunction declareFun(String name, int nofArgs, PrincessTermType returnType) {
        if (this.functionsCache.containsKey(name)) {
            assert (returnType == this.functionsReturnTypes.get(this.functionsCache.get(name)));
            return this.functionsCache.get(name);
        }
        IFunction funcDecl = this.api.createFunction(name, nofArgs);
        for (SymbolTrackingPrincessStack stack : this.allStacks) {
            stack.addSymbol(funcDecl);
        }
        this.functionsCache.put(name, funcDecl);
        this.functionsReturnTypes.put(funcDecl, returnType);
        return funcDecl;
    }

    PrincessTermType getReturnTypeForFunction(IFunction fun) {
        return this.functionsReturnTypes.get(fun);
    }

    public ITerm makeSelect(ITerm array, ITerm index) {
        ArrayList args = Lists.newArrayList((Object[])new ITerm[]{array, index});
        return this.api.select(JavaConversions.iterableAsScalaIterable((java.lang.Iterable)args).toSeq());
    }

    public ITerm makeStore(ITerm array, ITerm index, ITerm value) {
        ArrayList args = Lists.newArrayList((Object[])new ITerm[]{array, index, value});
        return this.api.store(JavaConversions.iterableAsScalaIterable((java.lang.Iterable)args).toSeq());
    }

    public boolean hasArrayType(IExpression exp) {
        return this.arrayVariablesCache.containsValue(exp) || exp instanceof IFunApp && ((IFunApp)exp).fun().toString().equals("store/3");
    }

    public IFormula elimQuantifiers(IFormula formula) {
        return this.api.simplify(formula);
    }

    public String getVersion() {
        return "Princess (unknown version)";
    }
}

