/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.LongArrayBackedList;
import org.sosy_lab.solver.mathsat5.Mathsat5AbstractProver;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaCreator;
import org.sosy_lab.solver.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.solver.mathsat5.Mathsat5NativeApi;
import org.sosy_lab.solver.mathsat5.Mathsat5SolverContext;

class Mathsat5TheoremProver
extends Mathsat5AbstractProver<Void>
implements ProverEnvironment {
    private final ShutdownNotifier shutdownNotifier;

    Mathsat5TheoremProver(Mathsat5SolverContext pMgr, ShutdownNotifier pShutdownNotifier, Mathsat5FormulaCreator creator, SolverContext.ProverOptions ... options) {
        super(pMgr, Mathsat5TheoremProver.createConfig(options), creator);
        this.shutdownNotifier = pShutdownNotifier;
    }

    private static Map<String, String> createConfig(SolverContext.ProverOptions ... options) {
        HashSet opts = Sets.newHashSet((Object[])options);
        return ImmutableMap.builder().put((Object)"model_generation", (Object)(opts.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS) ? "true" : "false")).put((Object)"unsat_core_generation", (Object)(opts.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE) ? "1" : "0")).build();
    }

    @Override
    @Nullable
    public Void push(BooleanFormula f) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.push();
        this.addConstraint(f);
        return null;
    }

    @Override
    @Nullable
    public Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_assert_formula(this.curEnv, Mathsat5FormulaManager.getMsatTerm(constraint));
        return null;
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Mathsat5NativeApi.msat_push_backtrack_point(this.curEnv);
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] terms = Mathsat5NativeApi.msat_get_unsat_core(this.curEnv);
        ArrayList<BooleanFormula> result = new ArrayList<BooleanFormula>(terms.length);
        for (long t : terms) {
            result.add(this.context.getFormulaManager().encapsulateBooleanFormula(t));
        }
        return result;
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        long[] imp = new long[important.size()];
        int i = 0;
        for (BooleanFormula impF : important) {
            imp[i++] = Mathsat5FormulaManager.getMsatTerm(impF);
        }
        MathsatAllSatCallback<T> uCallback = new MathsatAllSatCallback<T>(callback);
        int numModels = Mathsat5NativeApi.msat_all_sat(this.curEnv, imp, uCallback);
        if (numModels == -1) {
            throw new RuntimeException("Error occurred during Mathsat allsat: " + Mathsat5NativeApi.msat_last_error_message(this.curEnv));
        }
        if (numModels == -2) {
            throw new SolverException("Number of models should be finite with boolean predicates");
        }
        return callback.getResult();
    }

    class MathsatAllSatCallback<T>
    implements Mathsat5NativeApi.AllSatModelCallback {
        private final ProverEnvironment.AllSatCallback<T> clientCallback;

        MathsatAllSatCallback(ProverEnvironment.AllSatCallback<T> pClientCallback) {
            this.clientCallback = pClientCallback;
        }

        @Override
        public void callback(long[] model) throws InterruptedException {
            Mathsat5TheoremProver.this.shutdownNotifier.shutdownIfNecessary();
            this.clientCallback.apply((List<BooleanFormula>)new LongArrayBackedList<BooleanFormula>(model){

                @Override
                protected BooleanFormula convert(long pE) {
                    return Mathsat5TheoremProver.this.context.getFormulaManager().encapsulateBooleanFormula(pE);
                }
            });
        }
    }
}

