/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.logging;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.SolverException;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.api.ProverEnvironment;

public class LoggingProverEnvironment
implements ProverEnvironment {
    private final ProverEnvironment wrapped;
    private final LogManager logger;
    int level = 0;

    public LoggingProverEnvironment(LogManager logger, ProverEnvironment pe) {
        this.wrapped = (ProverEnvironment)Preconditions.checkNotNull((Object)pe);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)logger);
    }

    @Override
    public Void push(BooleanFormula f) {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.logger.log(Level.FINE, new Object[]{"formula pushed:", f});
        return (Void)this.wrapped.push(f);
    }

    @Override
    public void pop() {
        this.logger.log(Level.FINER, new Object[]{"down to level " + this.level--});
        this.wrapped.pop();
    }

    @Override
    public Void addConstraint(BooleanFormula constraint) {
        return (Void)this.wrapped.addConstraint(constraint);
    }

    @Override
    public void push() {
        this.logger.log(Level.FINE, new Object[]{"up to level " + this.level++});
        this.wrapped.push();
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        boolean result = this.wrapped.isUnsat();
        this.logger.log(Level.FINE, new Object[]{"unsat-check returned:", result});
        return result;
    }

    @Override
    public Model getModel() throws SolverException {
        Model m = this.wrapped.getModel();
        this.logger.log(Level.FINE, new Object[]{"model", m});
        return m;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        List<BooleanFormula> unsatCore = this.wrapped.getUnsatCore();
        this.logger.log(Level.FINE, new Object[]{"unsat-core", unsatCore});
        return unsatCore;
    }

    @Override
    public <T> T allSat(ProverEnvironment.AllSatCallback<T> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        T result = this.wrapped.allSat(callback, important);
        this.logger.log(Level.FINE, new Object[]{"allsat-result:", result});
        return result;
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.logger.log(Level.FINER, new Object[]{"closed"});
    }
}

