/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl.tactics;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;

class CNFVisitor
implements BooleanFormulaVisitor<List<BooleanFormula>> {
    private final BooleanFormulaManager bfmgr;
    private final int maxDepth;
    private int currentDepth = 0;

    CNFVisitor(BooleanFormulaManager pBfmgr, int pMaxDepth) {
        this.bfmgr = pBfmgr;
        this.maxDepth = pMaxDepth;
    }

    @Override
    public List<BooleanFormula> visitTrue() {
        return Collections.singletonList(this.bfmgr.makeBoolean(true));
    }

    @Override
    public List<BooleanFormula> visitFalse() {
        return Collections.singletonList(this.bfmgr.makeBoolean(false));
    }

    @Override
    public List<BooleanFormula> visitBoundVar(BooleanFormula var, int deBruijnIdx) {
        throw new IllegalStateException("Traversed formula is not in NNF if quantifiers are present");
    }

    @Override
    public List<BooleanFormula> visitAtom(BooleanFormula pAtom, FunctionDeclaration decl) {
        return Collections.singletonList(pAtom);
    }

    @Override
    public List<BooleanFormula> visitNot(BooleanFormula pOperand) {
        return Collections.singletonList(this.bfmgr.not(pOperand));
    }

    private List<List<BooleanFormula>> visitAll(List<BooleanFormula> pOperands) {
        ArrayList<List<BooleanFormula>> args = new ArrayList<List<BooleanFormula>>(pOperands.size());
        for (BooleanFormula arg : pOperands) {
            args.add(this.bfmgr.visit(this, arg));
        }
        return args;
    }

    @Override
    public List<BooleanFormula> visitAnd(List<BooleanFormula> pOperands) {
        if (this.maxDepth >= 0 && this.currentDepth > this.maxDepth) {
            return Collections.singletonList(this.bfmgr.and(pOperands));
        }
        ++this.currentDepth;
        FluentIterable operands = FluentIterable.from((Iterable)Iterables.concat(this.visitAll(pOperands)));
        if (operands.anyMatch((Predicate)new Predicate<BooleanFormula>(){

            public boolean apply(BooleanFormula pInput) {
                return CNFVisitor.this.bfmgr.isFalse(pInput);
            }
        })) {
            return Collections.singletonList(this.bfmgr.makeBoolean(false));
        }
        --this.currentDepth;
        return operands.toList();
    }

    @Override
    public List<BooleanFormula> visitOr(List<BooleanFormula> pOperands) {
        if (this.maxDepth >= 0 && this.currentDepth > this.maxDepth) {
            return Collections.singletonList(this.bfmgr.or(pOperands));
        }
        ++this.currentDepth;
        FluentIterable operands = FluentIterable.from(this.visitAll(pOperands));
        ArrayList<BooleanFormula> newConjuncts = new ArrayList<BooleanFormula>();
        for (List op : operands) {
            if (newConjuncts.isEmpty()) {
                newConjuncts.addAll(op);
                continue;
            }
            ArrayList<BooleanFormula> tmpConjuncts = new ArrayList<BooleanFormula>();
            for (BooleanFormula nextF : op) {
                for (BooleanFormula oldF : newConjuncts) {
                    tmpConjuncts.add(this.bfmgr.or(nextF, oldF));
                }
            }
            newConjuncts = tmpConjuncts;
        }
        --this.currentDepth;
        return newConjuncts;
    }

    @Override
    public List<BooleanFormula> visitXor(BooleanFormula operand1, BooleanFormula operand2) {
        throw new IllegalStateException("Traversed formula is not in NNF if XOR is present");
    }

    @Override
    public List<BooleanFormula> visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        throw new IllegalStateException("Traversed formula is not in NNF if equivalence is present");
    }

    @Override
    public List<BooleanFormula> visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
        throw new IllegalStateException("Traversed formula is not in NNF if implication is present");
    }

    @Override
    public List<BooleanFormula> visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThtmpConjunctsenFormula, BooleanFormula pElseFormula) {
        throw new IllegalStateException("Traversed formula is not in NNF without ITEs");
    }

    @Override
    public List<BooleanFormula> visitQuantifier(QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVars, BooleanFormula pBody) {
        throw new IllegalStateException("Traversed formula is not in NNF if quantifiers are present");
    }
}

