/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.Model;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.visitors.ExpectedFormulaVisitor;

public class TermExtractionModelIterator<E>
extends UnmodifiableIterator<Model.ValueAssignment> {
    private final Iterator<Map.Entry<E, Object>> valuesIterator;
    private final FormulaCreator<E, ?, ?> creator;
    private final Function<E, Object> evaluator;

    public TermExtractionModelIterator(FormulaCreator<E, ?, ?> creator, Function<E, Object> evaluator, Iterable<E> assertedTerms) {
        Preconditions.checkNotNull(assertedTerms);
        this.creator = (FormulaCreator)Preconditions.checkNotNull(creator);
        this.evaluator = (Function)Preconditions.checkNotNull(evaluator);
        HashMap<E, Object> values = new HashMap<E, Object>();
        for (E t : assertedTerms) {
            for (E key : creator.extractVariablesAndUFs(t, true).values()) {
                Object value = evaluator.apply(key);
                if (value == null) continue;
                Object existingValue = values.get(key);
                Verify.verify((existingValue == null || value.equals(existingValue) ? 1 : 0) != 0, (String)"Duplicate values for model entry %s: %s and %s", (Object[])new Object[]{key, existingValue, value});
                values.put(key, value);
            }
        }
        this.valuesIterator = values.entrySet().iterator();
    }

    public boolean hasNext() {
        return this.valuesIterator.hasNext();
    }

    public Model.ValueAssignment next() {
        Map.Entry<E, Object> entry = this.valuesIterator.next();
        Formula encapsulated = this.creator.encapsulateWithTypeOf(entry.getKey());
        final ArrayList varInterpretation = new ArrayList();
        String varName = this.creator.visit(new ExpectedFormulaVisitor<String>(){

            @Override
            public String visitFreeVariable(Formula f, String name) {
                return name;
            }

            @Override
            public String visitFunction(Formula f, List<Formula> args, FunctionDeclaration functionDeclaration, Function<List<Formula>, Formula> newApplicationConstructor) {
                for (Formula arg : args) {
                    varInterpretation.add(TermExtractionModelIterator.this.evaluator.apply(TermExtractionModelIterator.this.creator.extractInfo(arg)));
                }
                return functionDeclaration.getName();
            }
        }, encapsulated);
        return new Model.ValueAssignment(encapsulated, varName, entry.getValue(), varInterpretation);
    }
}

