/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

final class RecursiveFormulaVisitor
implements FormulaVisitor<TraversalProcess> {
    private final Set<Formula> seen = new HashSet<Formula>();
    private final Deque<Formula> toVisit = new ArrayDeque<Formula>();
    private final FormulaVisitor<TraversalProcess> delegate;

    RecursiveFormulaVisitor(FormulaVisitor<TraversalProcess> pDelegate) {
        this.delegate = (FormulaVisitor)Preconditions.checkNotNull(pDelegate);
    }

    void addToQueue(Formula f) {
        if (this.seen.add(f)) {
            this.toVisit.push(f);
        }
    }

    boolean isQueueEmpty() {
        return this.toVisit.isEmpty();
    }

    Formula pop() {
        return this.toVisit.pop();
    }

    @Override
    public TraversalProcess visitFreeVariable(Formula pF, String pName) {
        return this.delegate.visitFreeVariable(pF, pName);
    }

    @Override
    public TraversalProcess visitBoundVariable(Formula pF, int pDeBruijnIdx) {
        return this.delegate.visitBoundVariable(pF, pDeBruijnIdx);
    }

    @Override
    public TraversalProcess visitConstant(Formula pF, Object pValue) {
        return this.delegate.visitConstant(pF, pValue);
    }

    @Override
    public TraversalProcess visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration pFunctionDeclaration, Function<List<Formula>, Formula> pNewApplicationConstructor) {
        TraversalProcess result = this.delegate.visitFunction(pF, pArgs, pFunctionDeclaration, pNewApplicationConstructor);
        if (result == TraversalProcess.CONTINUE) {
            for (Formula arg : pArgs) {
                this.addToQueue(arg);
            }
        }
        return result;
    }

    @Override
    public TraversalProcess visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> boundVars, BooleanFormula pBody) {
        TraversalProcess result = this.delegate.visitQuantifier(pF, pQuantifier, boundVars, pBody);
        if (result == TraversalProcess.CONTINUE) {
            this.addToQueue(pBody);
        }
        return result;
    }
}

